<?php
/**
 * HoneypotGuard Settings View
 *
 * @package HoneypotGuard
 */

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- View file variables are local scope

if (!defined('ABSPATH')) {
    exit;
}

$options = $this->options;
$landing_url = honeypot_guard_url('landing_page');
$support_url = honeypot_guard_url('support');
?>

<div class="wrap honeypot-guard-wrap">
    <div class="oh-header">
        <h1>
            <span class="dashicons dashicons-shield-alt"></span>
            <?php honeypot_guard_e('settings_title'); ?>
        </h1>
        <p class="oh-subtitle"><?php honeypot_guard_e('settings_subtitle'); ?></p>
    </div>

    <form method="post" action="options.php" class="oh-settings-form">
        <?php settings_fields('honeypot_guard_options'); ?>

        <!-- Language Selection - Full Width -->
        <div class="oh-card oh-card-language" style="margin-bottom: 20px;">
            <div class="oh-card-header">
                <h2><span class="dashicons dashicons-translation"></span> <?php honeypot_guard_e('language_setting'); ?></h2>
            </div>
            <div class="oh-card-body">
                <div class="oh-field oh-field-text">
                    <label for="plugin_language"><?php honeypot_guard_e('language_setting'); ?></label>
                    <select name="honeypot_guard_options[plugin_language]" id="plugin_language" style="min-width: 200px;">
                        <?php foreach ($languages as $code => $name): ?>
                            <option value="<?php echo esc_attr($code); ?>" <?php selected($options['plugin_language'] ?? 'en', $code); ?>>
                                <?php echo esc_html($name); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <p class="description"><?php honeypot_guard_e('language_description'); ?></p>
                </div>
            </div>
        </div>

        <div class="oh-settings-grid">

            <!-- Honeypot Settings -->
            <div class="oh-card" data-card-id="honeypot">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-hidden"></span> <?php honeypot_guard_e('honeypot_protection'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_honeypot')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <div class="oh-field">
                        <label class="oh-toggle">
                            <input type="checkbox" name="honeypot_guard_options[honeypot_enabled]" value="1" <?php checked(!empty($options['honeypot_enabled'])); ?>>
                            <span class="oh-toggle-slider"></span>
                            <span class="oh-toggle-label"><?php honeypot_guard_e('enable_honeypot'); ?></span>
                        </label>
                        <p class="description"><?php honeypot_guard_e('honeypot_description'); ?></p>
                    </div>

                    <div class="oh-field oh-field-text">
                        <label for="honeypot_mode"><?php honeypot_guard_e('field_name_mode'); ?></label>
                        <select name="honeypot_guard_options[honeypot_mode]" id="honeypot_mode">
                            <option value="auto" <?php selected($options['honeypot_mode'] ?? 'auto', 'auto'); ?>><?php honeypot_guard_e('mode_auto'); ?></option>
                            <option value="dynamic" <?php selected($options['honeypot_mode'] ?? '', 'dynamic'); ?>><?php honeypot_guard_e('mode_dynamic'); ?></option>
                            <option value="custom" <?php selected($options['honeypot_mode'] ?? '', 'custom'); ?>><?php honeypot_guard_e('mode_custom'); ?></option>
                        </select>
                        <p class="description"><?php honeypot_guard_e('mode_description'); ?></p>
                    </div>

                    <div class="oh-field oh-field-text" id="rotation-setting" style="<?php echo ($options['honeypot_mode'] ?? 'auto') !== 'dynamic' ? 'display:none;' : ''; ?>">
                        <label for="honeypot_rotation"><?php honeypot_guard_e('rotation_frequency'); ?></label>
                        <select name="honeypot_guard_options[honeypot_rotation]" id="honeypot_rotation">
                            <option value="session" <?php selected($options['honeypot_rotation'] ?? 'session', 'session'); ?>><?php honeypot_guard_e('per_visitor_session'); ?></option>
                            <option value="hourly" <?php selected($options['honeypot_rotation'] ?? '', 'hourly'); ?>><?php honeypot_guard_e('hourly'); ?></option>
                            <option value="daily" <?php selected($options['honeypot_rotation'] ?? '', 'daily'); ?>><?php honeypot_guard_e('daily'); ?></option>
                        </select>
                    </div>

                    <div class="oh-field oh-field-text" id="custom-field-name" style="<?php echo ($options['honeypot_mode'] ?? 'auto') !== 'custom' ? 'display:none;' : ''; ?>">
                        <label for="honeypot_field_name"><?php honeypot_guard_e('custom_field_name'); ?></label>
                        <input type="text" name="honeypot_guard_options[honeypot_field_name]" id="honeypot_field_name" value="<?php echo esc_attr($options['honeypot_field_name'] ?? 'middle_name'); ?>" class="regular-text">
                    </div>

                    <div class="oh-field">
                        <label for="honeypot_custom_names"><?php honeypot_guard_e('additional_field_names'); ?></label>
                        <textarea name="honeypot_guard_options[honeypot_custom_names]" id="honeypot_custom_names" rows="3" class="large-text code"><?php echo esc_textarea($options['honeypot_custom_names'] ?? ''); ?></textarea>
                        <p class="description"><?php honeypot_guard_e('additional_names_description'); ?></p>
                    </div>

                    <div class="oh-field">
                        <label class="oh-toggle">
                            <input type="checkbox" name="honeypot_guard_options[honeypot_inject_js]" value="1" <?php checked($options['honeypot_inject_js'] ?? true); ?>>
                            <span class="oh-toggle-slider"></span>
                            <span class="oh-toggle-label"><?php honeypot_guard_e('inject_via_js'); ?></span>
                        </label>
                        <p class="description"><?php honeypot_guard_e('inject_js_description'); ?></p>
                    </div>

                    <div class="oh-field">
                        <label class="oh-toggle">
                            <input type="checkbox" name="honeypot_guard_options[honeypot_multiple]" value="1" <?php checked(!empty($options['honeypot_multiple'])); ?>>
                            <span class="oh-toggle-slider"></span>
                            <span class="oh-toggle-label"><?php honeypot_guard_e('multiple_honeypots'); ?></span>
                        </label>
                        <p class="description"><?php honeypot_guard_e('multiple_honeypots_description'); ?></p>
                    </div>
                </div>
            </div>

            <!-- Registration Form Protection -->
            <div class="oh-card" data-card-id="registration">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-admin-users"></span> <?php honeypot_guard_e('registration_protection'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_registration')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <div class="oh-field">
                        <label class="oh-toggle">
                            <input type="checkbox" name="honeypot_guard_options[protect_registration_forms]" value="1" <?php checked(!empty($options['protect_registration_forms'])); ?>>
                            <span class="oh-toggle-slider"></span>
                            <span class="oh-toggle-label"><?php honeypot_guard_e('enable_registration_protection'); ?></span>
                        </label>
                        <p class="description"><?php honeypot_guard_e('registration_protection_description'); ?></p>
                    </div>

                    <div class="oh-info-box" style="margin-top: 15px;">
                        <span class="dashicons dashicons-info"></span>
                        <div>
                            <strong><?php honeypot_guard_e('protected_forms'); ?>:</strong>
                            <ul style="margin: 5px 0 0 20px; list-style: disc;">
                                <li><?php honeypot_guard_e('wp_registration'); ?></li>
                                <li><?php honeypot_guard_e('woo_account_registration'); ?></li>
                                <li><?php honeypot_guard_e('woo_checkout_registration'); ?></li>
                            </ul>
                            <p class="description" style="margin-top: 10px;">
                                <?php honeypot_guard_e('registration_conversion_note'); ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Timestamp Check -->
            <div class="oh-card" data-card-id="timestamp">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-clock"></span> <?php honeypot_guard_e('timestamp_protection'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_timestamp')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <div class="oh-field">
                        <label class="oh-toggle">
                            <input type="checkbox" name="honeypot_guard_options[timestamp_enabled]" value="1" <?php checked(!empty($options['timestamp_enabled'])); ?>>
                            <span class="oh-toggle-slider"></span>
                            <span class="oh-toggle-label"><?php honeypot_guard_e('enable_timestamp'); ?></span>
                        </label>
                    </div>

                    <div class="oh-field oh-field-text">
                        <label for="min_submission_time"><?php honeypot_guard_e('min_time_seconds'); ?></label>
                        <input type="number" name="honeypot_guard_options[min_submission_time]" id="min_submission_time" value="<?php echo esc_attr($options['min_submission_time'] ?? 2); ?>" min="1" max="60" class="small-text">
                    </div>

                    <div class="oh-field oh-field-text">
                        <label for="max_submission_time"><?php honeypot_guard_e('session_expiry'); ?></label>
                        <input type="number" name="honeypot_guard_options[max_submission_time]" id="max_submission_time" value="<?php echo esc_attr($options['max_submission_time'] ?? 3600); ?>" min="60" max="86400" class="small-text">
                    </div>
                </div>
            </div>

            <!-- Rate Limiting -->
            <div class="oh-card" data-card-id="rate_limiting">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-performance"></span> <?php honeypot_guard_e('rate_limiting'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_rate_limiting')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <div class="oh-field">
                        <label class="oh-toggle">
                            <input type="checkbox" name="honeypot_guard_options[rate_limit_enabled]" value="1" <?php checked(!empty($options['rate_limit_enabled'])); ?>>
                            <span class="oh-toggle-slider"></span>
                            <span class="oh-toggle-label"><?php honeypot_guard_e('enable_rate_limiting'); ?></span>
                        </label>
                    </div>

                    <div class="oh-field oh-field-text">
                        <label for="rate_limit_submissions"><?php honeypot_guard_e('max_submissions'); ?></label>
                        <input type="number" name="honeypot_guard_options[rate_limit_submissions]" id="rate_limit_submissions" value="<?php echo esc_attr($options['rate_limit_submissions'] ?? 5); ?>" min="1" max="100" class="small-text">
                    </div>

                    <div class="oh-field oh-field-text">
                        <label for="rate_limit_window"><?php honeypot_guard_e('time_window'); ?></label>
                        <input type="number" name="honeypot_guard_options[rate_limit_window]" id="rate_limit_window" value="<?php echo esc_attr($options['rate_limit_window'] ?? 60); ?>" min="10" max="3600" class="small-text">
                    </div>
                </div>
            </div>

            <!-- Character Filtering -->
            <div class="oh-card" data-card-id="character_filtering">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-translation"></span> <?php honeypot_guard_e('character_filtering'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_character_filtering')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <div class="oh-field">
                        <label class="oh-toggle">
                            <input type="checkbox" name="honeypot_guard_options[cyrillic_filter]" value="1" <?php checked(!empty($options['cyrillic_filter'])); ?>>
                            <span class="oh-toggle-slider"></span>
                            <span class="oh-toggle-label"><?php honeypot_guard_e('block_cyrillic'); ?></span>
                        </label>
                    </div>

                    <div class="oh-field">
                        <label class="oh-toggle">
                            <input type="checkbox" name="honeypot_guard_options[hanzi_filter]" value="1" <?php checked(!empty($options['hanzi_filter'])); ?>>
                            <span class="oh-toggle-slider"></span>
                            <span class="oh-toggle-label"><?php honeypot_guard_e('block_chinese'); ?></span>
                        </label>
                    </div>

                    <div class="oh-field">
                        <label class="oh-toggle">
                            <input type="checkbox" name="honeypot_guard_options[bengali_filter]" value="1" <?php checked(!empty($options['bengali_filter'])); ?>>
                            <span class="oh-toggle-slider"></span>
                            <span class="oh-toggle-label"><?php honeypot_guard_e('block_south_asian'); ?></span>
                        </label>
                        <p class="description"><?php honeypot_guard_e('block_south_asian_desc'); ?></p>
                    </div>

                    <div class="oh-field">
                        <label class="oh-toggle">
                            <input type="checkbox" name="honeypot_guard_options[latin_filter]" value="1" <?php checked(!empty($options['latin_filter'])); ?>>
                            <span class="oh-toggle-slider"></span>
                            <span class="oh-toggle-label"><?php honeypot_guard_e('block_latin'); ?></span>
                        </label>
                        <p class="description oh-warning-text"><?php honeypot_guard_e('block_latin_warning'); ?></p>
                    </div>
                </div>
            </div>

            <!-- Email Blacklist -->
            <div class="oh-card" data-card-id="email_blacklist">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-email"></span> <?php honeypot_guard_e('email_blacklist'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_email_blacklist')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <div class="oh-field">
                        <label for="blacklist_emails"><?php honeypot_guard_e('blocked_emails'); ?></label>
                        <textarea name="honeypot_guard_options[blacklist_emails]" id="blacklist_emails" rows="4" class="large-text code"><?php echo esc_textarea($options['blacklist_emails'] ?? ''); ?></textarea>
                        <p class="description"><?php honeypot_guard_e('supports_wildcards'); ?></p>
                    </div>
                </div>
            </div>

            <!-- Domain Blacklist -->
            <div class="oh-card" data-card-id="domain_blacklist">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-admin-site-alt3"></span> <?php honeypot_guard_e('domain_blacklist'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_domain_blacklist')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <div class="oh-field">
                        <label for="blacklist_domains"><?php honeypot_guard_e('blocked_domains'); ?></label>
                        <textarea name="honeypot_guard_options[blacklist_domains]" id="blacklist_domains" rows="4" class="large-text code"><?php echo esc_textarea($options['blacklist_domains'] ?? ''); ?></textarea>
                        <p class="description"><?php honeypot_guard_e('use_wildcard_subdomain'); ?></p>
                    </div>
                </div>
            </div>

            <!-- IP Blacklist -->
            <div class="oh-card" data-card-id="ip_blacklist">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-admin-network"></span> <?php honeypot_guard_e('ip_blacklist'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_ip_blacklist')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <div class="oh-field">
                        <label for="blacklist_ips"><?php honeypot_guard_e('blocked_ips'); ?></label>
                        <textarea name="honeypot_guard_options[blacklist_ips]" id="blacklist_ips" rows="4" class="large-text code"><?php echo esc_textarea($options['blacklist_ips'] ?? ''); ?></textarea>
                        <p class="description"><?php honeypot_guard_e('supports_cidr'); ?></p>
                    </div>
                </div>
            </div>

            <!-- Subject Keywords -->
            <div class="oh-card" data-card-id="keywords_subject">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-text-page"></span> <?php honeypot_guard_e('keyword_blacklist_subject'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_keywords')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <div class="oh-field">
                        <label for="blacklist_keywords_subject"><?php honeypot_guard_e('block_if_subject_contains'); ?></label>
                        <textarea name="honeypot_guard_options[blacklist_keywords_subject]" id="blacklist_keywords_subject" rows="4" class="large-text code"><?php echo esc_textarea($options['blacklist_keywords_subject'] ?? ''); ?></textarea>
                    </div>
                </div>
            </div>

            <!-- Body Keywords -->
            <div class="oh-card" data-card-id="keywords_body">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-editor-paragraph"></span> <?php honeypot_guard_e('keyword_blacklist_body'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_keywords')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <div class="oh-field">
                        <label for="blacklist_keywords_body"><?php honeypot_guard_e('block_if_body_contains'); ?></label>
                        <textarea name="honeypot_guard_options[blacklist_keywords_body]" id="blacklist_keywords_body" rows="4" class="large-text code"><?php echo esc_textarea($options['blacklist_keywords_body'] ?? ''); ?></textarea>
                    </div>
                </div>
            </div>

            <!-- Global Keywords -->
            <div class="oh-card" data-card-id="keywords_global">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-list-view"></span> <?php honeypot_guard_e('keyword_blacklist_all'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_keywords')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <div class="oh-field">
                        <label for="blacklist_keywords_all"><?php honeypot_guard_e('block_if_any_contains'); ?></label>
                        <textarea name="honeypot_guard_options[blacklist_keywords_all]" id="blacklist_keywords_all" rows="4" class="large-text code"><?php echo esc_textarea($options['blacklist_keywords_all'] ?? ''); ?></textarea>
                    </div>
                </div>
            </div>

            <!-- Heuristic Analysis -->
            <div class="oh-card" data-card-id="smart_detection">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-lightbulb"></span> <?php honeypot_guard_e('smart_detection'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_smart_detection')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <div class="oh-field">
                        <label class="oh-toggle">
                            <input type="checkbox" name="honeypot_guard_options[heuristic_enabled]" value="1" <?php checked(!empty($options['heuristic_enabled'])); ?>>
                            <span class="oh-toggle-slider"></span>
                            <span class="oh-toggle-label"><?php honeypot_guard_e('enable_heuristic'); ?></span>
                        </label>
                    </div>

                    <div class="oh-field oh-field-text">
                        <label for="max_links"><?php honeypot_guard_e('max_links_allowed'); ?></label>
                        <input type="number" name="honeypot_guard_options[max_links]" id="max_links" value="<?php echo esc_attr($options['max_links'] ?? 3); ?>" min="0" max="50" class="small-text">
                    </div>

                    <div class="oh-field oh-field-text">
                        <label for="spam_threshold"><?php honeypot_guard_e('spam_threshold'); ?></label>
                        <input type="number" name="honeypot_guard_options[spam_threshold]" id="spam_threshold" value="<?php echo esc_attr($options['spam_threshold'] ?? 70); ?>" min="1" max="200" class="small-text">
                    </div>
                </div>
            </div>

            <!-- Security -->
            <div class="oh-card" data-card-id="security">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-lock"></span> <?php honeypot_guard_e('security'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_security')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <div class="oh-field">
                        <label class="oh-toggle">
                            <input type="checkbox" name="honeypot_guard_options[require_referer]" value="1" <?php checked(!empty($options['require_referer'])); ?>>
                            <span class="oh-toggle-slider"></span>
                            <span class="oh-toggle-label"><?php honeypot_guard_e('require_referer'); ?></span>
                        </label>
                    </div>

                    <div class="oh-field">
                        <label class="oh-toggle">
                            <input type="checkbox" name="honeypot_guard_options[cookie_check_enabled]" value="1" <?php checked(!empty($options['cookie_check_enabled'])); ?>>
                            <span class="oh-toggle-slider"></span>
                            <span class="oh-toggle-label"><?php honeypot_guard_e('enable_cookie_check'); ?></span>
                        </label>
                        <p class="description"><?php honeypot_guard_e('cookie_check_description'); ?></p>
                    </div>

                    <div class="oh-field">
                        <label class="oh-toggle">
                            <input type="checkbox" name="honeypot_guard_options[whitelist_logged_in]" value="1" <?php checked(!empty($options['whitelist_logged_in'])); ?>>
                            <span class="oh-toggle-slider"></span>
                            <span class="oh-toggle-label"><?php honeypot_guard_e('whitelist_admins'); ?></span>
                        </label>
                        <p class="description" style="margin-top: 5px; color: #d63638;">
                            <strong><?php honeypot_guard_e('note'); ?>:</strong>
                            <?php honeypot_guard_e('whitelist_admins_note'); ?>
                        </p>
                    </div>
                </div>
            </div>

            <!-- Logging -->
            <div class="oh-card" data-card-id="logging">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-database"></span> <?php honeypot_guard_e('logging'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_logging')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <div class="oh-field oh-field-text">
                        <label for="log_retention_days"><?php honeypot_guard_e('retention_days'); ?></label>
                        <input type="number" name="honeypot_guard_options[log_retention_days]" id="log_retention_days" value="<?php echo esc_attr($options['log_retention_days'] ?? 30); ?>" min="1" max="365" class="small-text">
                    </div>

                    <div class="oh-field">
                        <label class="oh-toggle">
                            <input type="checkbox" name="honeypot_guard_options[log_clean_submissions]" value="1" <?php checked(!empty($options['log_clean_submissions'])); ?>>
                            <span class="oh-toggle-slider"></span>
                            <span class="oh-toggle-label"><?php honeypot_guard_e('log_clean_submissions'); ?></span>
                        </label>
                    </div>
                </div>
            </div>

            <!-- Escalation -->
            <div class="oh-card" data-card-id="escalation">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-megaphone"></span> <?php honeypot_guard_e('escalation'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_escalation')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <div class="oh-field oh-field-text">
                        <label for="escalation_threshold"><?php honeypot_guard_e('alert_after'); ?></label>
                        <input type="number" name="honeypot_guard_options[escalation_threshold]" id="escalation_threshold" value="<?php echo esc_attr($options['escalation_threshold'] ?? 3); ?>" min="1" max="100" class="small-text"> <?php honeypot_guard_e('spam_submissions'); ?>
                    </div>

                    <div class="oh-field oh-field-text">
                        <label for="escalation_window"><?php honeypot_guard_e('within'); ?></label>
                        <input type="number" name="honeypot_guard_options[escalation_window]" id="escalation_window" value="<?php echo esc_attr($options['escalation_window'] ?? 60); ?>" min="1" max="1440" class="small-text"> <?php honeypot_guard_e('minutes'); ?>
                    </div>
                </div>
            </div>

            <!-- AI Gibberish Detection -->
            <div class="oh-card oh-card-ai" data-card-id="ai_gibberish">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-superhero"></span> <?php honeypot_guard_e('ai_gibberish_detection'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-badge oh-badge-pro"><?php honeypot_guard_e('ai_powered'); ?></span>
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_ai_gibberish')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <div class="oh-ai-info">
                        <p><?php honeypot_guard_e('ai_gibberish_description'); ?></p>
                    </div>

                    <div class="oh-field">
                        <label class="oh-toggle">
                            <input type="checkbox" name="honeypot_guard_options[gibberish_detection_enabled]" value="1" <?php checked(!empty($options['gibberish_detection_enabled'])); ?> id="gibberish_enabled">
                            <span class="oh-toggle-slider"></span>
                            <span class="oh-toggle-label"><?php honeypot_guard_e('enable_ai_gibberish'); ?></span>
                        </label>
                    </div>

                    <div class="oh-ai-settings" id="ai-settings-wrapper" style="<?php echo empty($options['gibberish_detection_enabled']) ? 'display:none;' : ''; ?>">
                        <div class="oh-field oh-field-text">
                            <label for="gibberish_ai_provider"><?php honeypot_guard_e('ai_provider'); ?></label>
                            <select name="honeypot_guard_options[gibberish_ai_provider]" id="gibberish_ai_provider">
                                <option value="openai" <?php selected($options['gibberish_ai_provider'] ?? 'openai', 'openai'); ?>>OpenAI (GPT-4o-mini)</option>
                                <option value="anthropic" <?php selected($options['gibberish_ai_provider'] ?? '', 'anthropic'); ?>>Anthropic (Claude Haiku)</option>
                            </select>
                        </div>

                        <div class="oh-field oh-field-text">
                            <label for="gibberish_api_key"><?php honeypot_guard_e('api_key'); ?></label>
                            <input type="password" name="honeypot_guard_options[gibberish_api_key]" id="gibberish_api_key" value="<?php echo esc_attr($options['gibberish_api_key'] ?? ''); ?>" class="large-text" autocomplete="off">
                            <p class="description">
                                <?php honeypot_guard_e('get_api_key_from'); ?>
                                <a href="https://platform.openai.com/api-keys" target="_blank">OpenAI</a> <?php honeypot_guard_e('or'); ?>
                                <a href="https://console.anthropic.com/" target="_blank">Anthropic</a>
                            </p>
                        </div>

                        <div class="oh-field oh-field-text">
                            <label for="gibberish_language"><?php honeypot_guard_e('default_language'); ?></label>
                            <select name="honeypot_guard_options[gibberish_language]" id="gibberish_language">
                                <option value="auto" <?php selected($options['gibberish_language'] ?? 'auto', 'auto'); ?>><?php honeypot_guard_e('auto_detect_wpml'); ?></option>
                                <option value="en" <?php selected($options['gibberish_language'] ?? '', 'en'); ?>>English</option>
                                <option value="lt" <?php selected($options['gibberish_language'] ?? '', 'lt'); ?>>Lithuanian</option>
                                <option value="lv" <?php selected($options['gibberish_language'] ?? '', 'lv'); ?>>Latvian</option>
                                <option value="et" <?php selected($options['gibberish_language'] ?? '', 'et'); ?>>Estonian</option>
                                <option value="de" <?php selected($options['gibberish_language'] ?? '', 'de'); ?>>German</option>
                                <option value="fr" <?php selected($options['gibberish_language'] ?? '', 'fr'); ?>>French</option>
                                <option value="es" <?php selected($options['gibberish_language'] ?? '', 'es'); ?>>Spanish</option>
                                <option value="it" <?php selected($options['gibberish_language'] ?? '', 'it'); ?>>Italian</option>
                                <option value="pt" <?php selected($options['gibberish_language'] ?? '', 'pt'); ?>>Portuguese</option>
                                <option value="nl" <?php selected($options['gibberish_language'] ?? '', 'nl'); ?>>Dutch</option>
                                <option value="pl" <?php selected($options['gibberish_language'] ?? '', 'pl'); ?>>Polish</option>
                                <option value="cs" <?php selected($options['gibberish_language'] ?? '', 'cs'); ?>>Czech</option>
                                <option value="sk" <?php selected($options['gibberish_language'] ?? '', 'sk'); ?>>Slovak</option>
                                <option value="hu" <?php selected($options['gibberish_language'] ?? '', 'hu'); ?>>Hungarian</option>
                                <option value="ro" <?php selected($options['gibberish_language'] ?? '', 'ro'); ?>>Romanian</option>
                                <option value="sv" <?php selected($options['gibberish_language'] ?? '', 'sv'); ?>>Swedish</option>
                                <option value="no" <?php selected($options['gibberish_language'] ?? '', 'no'); ?>>Norwegian</option>
                                <option value="da" <?php selected($options['gibberish_language'] ?? '', 'da'); ?>>Danish</option>
                                <option value="fi" <?php selected($options['gibberish_language'] ?? '', 'fi'); ?>>Finnish</option>
                                <option value="ru" <?php selected($options['gibberish_language'] ?? '', 'ru'); ?>>Russian</option>
                            </select>
                            <p class="description"><?php honeypot_guard_e('default_language_description'); ?></p>
                        </div>

                        <div class="oh-field oh-field-text">
                            <label for="gibberish_domain_languages"><?php honeypot_guard_e('per_domain_languages'); ?></label>
                            <textarea name="honeypot_guard_options[gibberish_domain_languages]" id="gibberish_domain_languages" rows="4" class="large-text code" placeholder="mantasdigital.com:lt,en&#10;md.lt:lt"><?php echo esc_textarea($options['gibberish_domain_languages'] ?? ''); ?></textarea>
                            <p class="description">
                                <?php honeypot_guard_e('per_domain_languages_description'); ?><br>
                                <strong><?php honeypot_guard_e('format'); ?>:</strong> <code>domain.com:lang1,lang2</code><br><br>
                                <strong><?php honeypot_guard_e('examples'); ?>:</strong><br>
                                <code>mantasdigital.com:lt,en</code> → <?php honeypot_guard_e('accepts_lt_en'); ?><br>
                                <code>md.lt:lt</code> → <?php honeypot_guard_e('accepts_only_lt'); ?><br>
                                <code>example.de:de,en</code> → <?php honeypot_guard_e('accepts_de_en'); ?><br><br>
                                <strong><?php honeypot_guard_e('language_codes'); ?>:</strong> en, lt, lv, et, de, fr, es, it, pt, nl, pl, cs, sk, hu, ro, sv, no, da, fi, ru
                            </p>
                        </div>

                        <div class="oh-field oh-field-text">
                            <label for="gibberish_score"><?php honeypot_guard_e('spam_score_label'); ?></label>
                            <input type="number" name="honeypot_guard_options[gibberish_score]" id="gibberish_score" value="<?php echo esc_attr($options['gibberish_score'] ?? 85); ?>" min="1" max="100" class="small-text">
                            <p class="description"><?php honeypot_guard_e('spam_score_description'); ?></p>
                        </div>

                        <div class="oh-field oh-field-text">
                            <label for="gibberish_min_length"><?php honeypot_guard_e('min_text_length'); ?></label>
                            <input type="number" name="honeypot_guard_options[gibberish_min_length]" id="gibberish_min_length" value="<?php echo esc_attr($options['gibberish_min_length'] ?? 5); ?>" min="3" max="50" class="small-text">
                            <p class="description"><?php honeypot_guard_e('min_text_length_description'); ?></p>
                        </div>

                        <div class="oh-ai-cost-notice">
                            <span class="dashicons dashicons-info"></span>
                            <p><?php honeypot_guard_e('ai_cost_notice'); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Spam Messages -->
            <div class="oh-card" data-card-id="spam_messages">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-format-status"></span> <?php honeypot_guard_e('spam_error_messages'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_spam_messages')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <p class="description" style="margin-bottom: 15px;">
                        <?php honeypot_guard_e('spam_messages_description'); ?>
                    </p>

                    <div class="oh-field">
                        <label for="spam_message_mode"><strong><?php honeypot_guard_e('message_mode'); ?></strong></label>
                        <select name="honeypot_guard_options[spam_message_mode]" id="spam_message_mode" class="oh-select">
                            <option value="auto" <?php selected($options['spam_message_mode'] ?? 'auto', 'auto'); ?>>
                                <?php honeypot_guard_e('mode_auto_detect'); ?>
                            </option>
                            <option value="custom" <?php selected($options['spam_message_mode'] ?? '', 'custom'); ?>>
                                <?php honeypot_guard_e('mode_custom_single'); ?>
                            </option>
                            <option value="per_domain" <?php selected($options['spam_message_mode'] ?? '', 'per_domain'); ?>>
                                <?php honeypot_guard_e('mode_per_domain'); ?>
                            </option>
                        </select>
                    </div>

                    <!-- Custom Message (shown when mode is 'custom') -->
                    <div class="oh-field oh-field-text oh-conditional-field" data-show-when="spam_message_mode" data-show-value="custom">
                        <label for="custom_spam_message"><?php honeypot_guard_e('custom_message'); ?></label>
                        <input type="text" name="honeypot_guard_options[custom_spam_message]" id="custom_spam_message" value="<?php echo esc_attr($options['custom_spam_message'] ?? ''); ?>" class="large-text" placeholder="Your submission could not be processed. Please try again.">
                        <p class="description"><?php honeypot_guard_e('custom_message_description'); ?></p>
                    </div>

                    <!-- Per-Domain Messages (shown when mode is 'per_domain') -->
                    <div class="oh-field oh-field-text oh-conditional-field" data-show-when="spam_message_mode" data-show-value="per_domain">
                        <label for="spam_messages_per_domain"><?php honeypot_guard_e('messages_per_domain'); ?></label>
                        <textarea name="honeypot_guard_options[spam_messages_per_domain]" id="spam_messages_per_domain" rows="6" class="large-text code" placeholder="md.lt|Jūsų žinutė negalėjo būti išsiųsta. Bandykite dar kartą.&#10;mantasdigital.com|Your message could not be sent. Please try again."><?php echo esc_textarea($options['spam_messages_per_domain'] ?? ''); ?></textarea>
                        <p class="description">
                            <?php honeypot_guard_e('messages_per_domain_description'); ?><br>
                            <strong><?php honeypot_guard_e('format'); ?>:</strong> <code>domain.com|Your error message here</code>
                        </p>
                    </div>

                    <!-- Default Message (shown when mode is 'per_domain') -->
                    <div class="oh-field oh-field-text oh-conditional-field" data-show-when="spam_message_mode" data-show-value="per_domain">
                        <label for="spam_message_default"><?php honeypot_guard_e('default_message_fallback'); ?></label>
                        <input type="text" name="honeypot_guard_options[spam_message_default]" id="spam_message_default" value="<?php echo esc_attr($options['spam_message_default'] ?? ''); ?>" class="large-text" placeholder="Your submission could not be processed.">
                        <p class="description"><?php honeypot_guard_e('default_message_description'); ?></p>
                    </div>

                    <!-- Built-in Languages Info (shown when mode is 'auto') -->
                    <div class="oh-field oh-conditional-field" data-show-when="spam_message_mode" data-show-value="auto">
                        <div class="oh-info-box">
                            <span class="dashicons dashicons-translation"></span>
                            <div>
                                <strong><?php honeypot_guard_e('builtin_translations'); ?>:</strong>
                                <p><?php honeypot_guard_e('builtin_languages_list'); ?></p>
                                <p class="description"><?php honeypot_guard_e('auto_language_detection_note'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Advanced -->
            <div class="oh-card" data-card-id="advanced">
                <div class="oh-card-header oh-collapsible">
                    <h2><span class="dashicons dashicons-admin-tools"></span> <?php honeypot_guard_e('advanced'); ?></h2>
                    <div class="oh-card-controls">
                        <span class="oh-help-btn-wrap"><span class="oh-help-btn">?</span><span class="oh-help-tooltip"><?php echo esc_html(honeypot_guard_t('help_advanced')); ?></span></span>
                        <span class="dashicons dashicons-arrow-up-alt2 oh-collapse-icon"></span>
                    </div>
                </div>
                <div class="oh-card-body">
                    <div class="oh-field">
                        <label class="oh-toggle">
                            <input type="checkbox" name="honeypot_guard_options[delete_data_on_uninstall]" value="1" <?php checked(!empty($options['delete_data_on_uninstall'])); ?>>
                            <span class="oh-toggle-slider"></span>
                            <span class="oh-toggle-label"><?php honeypot_guard_e('delete_data_uninstall'); ?></span>
                        </label>
                    </div>
                </div>
            </div>

        </div>

        <div class="oh-submit-area">
            <?php submit_button(honeypot_guard_t('save_settings'), 'primary', 'submit', false); ?>
        </div>
    </form>

    <div class="oh-footer">
        <p>
            <?php honeypot_guard_e('footer_text'); ?> |
            <a href="<?php echo esc_url($landing_url); ?>" target="_blank">GitHub</a> |
            <a href="<?php echo esc_url($support_url); ?>" target="_blank"><?php honeypot_guard_e('report_issues'); ?></a>
        </p>
    </div>
</div>
