<?php
/**
 * HoneypotGuard Logs View
 *
 * @package HoneypotGuard
 */

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- View file variables are local scope

if (!defined('ABSPATH')) {
    exit;
}

$landing_url = honeypot_guard_url('landing_page');
?>

<div class="wrap honeypot-guard-wrap">
    <div class="oh-header">
        <h1>
            <span class="dashicons dashicons-shield-alt"></span>
            <?php honeypot_guard_e('spam_logs'); ?>
        </h1>
        <p class="oh-subtitle"><?php honeypot_guard_e('logs_subtitle'); ?></p>
    </div>

    <!-- Filter Form -->
    <div class="oh-card oh-filter-card" style="margin-bottom: 20px;">
        <div class="oh-card-header">
            <h3><span class="dashicons dashicons-filter"></span> <?php honeypot_guard_e('filters'); ?></h3>
            <button type="button" class="button button-small" id="oh-toggle-filters">
                <?php echo esc_html(!empty($has_filters) ? honeypot_guard_t('hide_filters') : honeypot_guard_t('show_filters')); ?>
            </button>
        </div>
        <div class="oh-card-body" id="oh-filters-panel" style="<?php echo empty($has_filters) ? 'display:none;' : ''; ?>">
            <form method="get" action="<?php echo esc_url(admin_url('admin.php')); ?>" class="oh-filter-form">
                <input type="hidden" name="page" value="honeypot-guard-logs">

                <div class="oh-filter-row">
                    <!-- Status Filter -->
                    <div class="oh-filter-group">
                        <label><?php honeypot_guard_e('status'); ?></label>
                        <select name="status">
                            <option value=""><?php honeypot_guard_e('all'); ?></option>
                            <option value="spam" <?php selected($status_filter, 'spam'); ?>><?php honeypot_guard_e('spam_only'); ?></option>
                            <option value="clean" <?php selected($status_filter, 'clean'); ?>><?php honeypot_guard_e('clean_only'); ?></option>
                        </select>
                    </div>

                    <!-- Spam Reason Filter -->
                    <div class="oh-filter-group">
                        <label><?php honeypot_guard_e('spam_type'); ?></label>
                        <select name="spam_type">
                            <option value=""><?php honeypot_guard_e('all_types'); ?></option>
                            <option value="honeypot" <?php selected($spam_type_filter ?? '', 'honeypot'); ?>><?php honeypot_guard_e('honeypot_triggered'); ?></option>
                            <option value="timestamp" <?php selected($spam_type_filter ?? '', 'timestamp'); ?>><?php honeypot_guard_e('timestamp_too_fast'); ?></option>
                            <option value="blacklist" <?php selected($spam_type_filter ?? '', 'blacklist'); ?>><?php honeypot_guard_e('blacklisted'); ?></option>
                            <option value="cyrillic" <?php selected($spam_type_filter ?? '', 'cyrillic'); ?>><?php honeypot_guard_e('cyrillic_chars'); ?></option>
                            <option value="hanzi" <?php selected($spam_type_filter ?? '', 'hanzi'); ?>><?php honeypot_guard_e('chinese_chars'); ?></option>
                            <option value="gibberish" <?php selected($spam_type_filter ?? '', 'gibberish'); ?>><?php honeypot_guard_e('gibberish_detected'); ?></option>
                            <option value="links" <?php selected($spam_type_filter ?? '', 'links'); ?>><?php honeypot_guard_e('too_many_links'); ?></option>
                            <option value="rate_limit" <?php selected($spam_type_filter ?? '', 'rate_limit'); ?>><?php honeypot_guard_e('rate_limited'); ?></option>
                            <option value="heuristic" <?php selected($spam_type_filter ?? '', 'heuristic'); ?>><?php honeypot_guard_e('heuristic_score'); ?></option>
                        </select>
                    </div>

                    <!-- Character Filter -->
                    <div class="oh-filter-group">
                        <label><?php honeypot_guard_e('character_filter'); ?></label>
                        <select name="char_filter">
                            <option value=""><?php honeypot_guard_e('no_filter'); ?></option>
                            <option value="has_cyrillic" <?php selected($char_filter ?? '', 'has_cyrillic'); ?>><?php honeypot_guard_e('has_cyrillic'); ?></option>
                            <option value="has_hanzi" <?php selected($char_filter ?? '', 'has_hanzi'); ?>><?php honeypot_guard_e('has_chinese'); ?></option>
                            <option value="has_foreign" <?php selected($char_filter ?? '', 'has_foreign'); ?>><?php honeypot_guard_e('has_foreign'); ?></option>
                            <option value="no_cyrillic" <?php selected($char_filter ?? '', 'no_cyrillic'); ?>><?php honeypot_guard_e('exclude_cyrillic'); ?></option>
                            <option value="no_hanzi" <?php selected($char_filter ?? '', 'no_hanzi'); ?>><?php honeypot_guard_e('exclude_chinese'); ?></option>
                            <option value="no_foreign" <?php selected($char_filter ?? '', 'no_foreign'); ?>><?php honeypot_guard_e('exclude_foreign'); ?></option>
                        </select>
                    </div>

                    <!-- Form Source Filter -->
                    <div class="oh-filter-group">
                        <label><?php honeypot_guard_e('form_source'); ?></label>
                        <select name="form_source">
                            <option value=""><?php honeypot_guard_e('all_sources'); ?></option>
                            <?php foreach ($form_sources ?? [] as $source): ?>
                                <option value="<?php echo esc_attr($source); ?>" <?php selected($form_source_filter ?? '', $source); ?>>
                                    <?php echo esc_html(ucfirst($source)); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>

                <div class="oh-filter-row">
                    <!-- Date Presets -->
                    <div class="oh-filter-group">
                        <label><?php honeypot_guard_e('date_range'); ?></label>
                        <select name="date_preset" id="oh-date-preset">
                            <option value=""><?php honeypot_guard_e('all_time'); ?></option>
                            <option value="today" <?php selected($date_preset ?? '', 'today'); ?>><?php honeypot_guard_e('today'); ?></option>
                            <option value="yesterday" <?php selected($date_preset ?? '', 'yesterday'); ?>><?php honeypot_guard_e('yesterday'); ?></option>
                            <option value="7days" <?php selected($date_preset ?? '', '7days'); ?>><?php honeypot_guard_e('last_7_days'); ?></option>
                            <option value="30days" <?php selected($date_preset ?? '', '30days'); ?>><?php honeypot_guard_e('last_30_days'); ?></option>
                            <option value="this_month" <?php selected($date_preset ?? '', 'this_month'); ?>><?php honeypot_guard_e('this_month'); ?></option>
                            <option value="last_month" <?php selected($date_preset ?? '', 'last_month'); ?>><?php honeypot_guard_e('last_month'); ?></option>
                            <option value="custom" <?php selected($date_preset ?? '', 'custom'); ?>><?php honeypot_guard_e('custom_range'); ?></option>
                        </select>
                    </div>

                    <!-- Custom Date From -->
                    <div class="oh-filter-group oh-custom-date" style="<?php echo ($date_preset ?? '') !== 'custom' ? 'display:none;' : ''; ?>">
                        <label><?php honeypot_guard_e('from_date'); ?></label>
                        <input type="date" name="date_from" value="<?php echo esc_attr($date_from ?? ''); ?>">
                    </div>

                    <!-- Custom Date To -->
                    <div class="oh-filter-group oh-custom-date" style="<?php echo ($date_preset ?? '') !== 'custom' ? 'display:none;' : ''; ?>">
                        <label><?php honeypot_guard_e('to_date'); ?></label>
                        <input type="date" name="date_to" value="<?php echo esc_attr($date_to ?? ''); ?>">
                    </div>

                    <!-- Specific Date -->
                    <div class="oh-filter-group">
                        <label><?php honeypot_guard_e('specific_date'); ?></label>
                        <input type="date" name="specific_date" value="<?php echo esc_attr($specific_date ?? ''); ?>">
                    </div>
                </div>

                <div class="oh-filter-row">
                    <!-- Search -->
                    <div class="oh-filter-group oh-filter-group-wide">
                        <label><?php honeypot_guard_e('search_content'); ?></label>
                        <input type="text" name="search" value="<?php echo esc_attr($search_filter ?? ''); ?>" placeholder="<?php echo esc_attr(honeypot_guard_t('search_placeholder')); ?>">
                    </div>

                    <!-- Filter Actions -->
                    <div class="oh-filter-group oh-filter-actions">
                        <button type="submit" class="button button-primary">
                            <span class="dashicons dashicons-search"></span> <?php honeypot_guard_e('apply_filters'); ?>
                        </button>
                        <a href="<?php echo esc_url(admin_url('admin.php?page=honeypot-guard-logs')); ?>" class="button">
                            <span class="dashicons dashicons-dismiss"></span> <?php honeypot_guard_e('clear'); ?>
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="oh-logs-toolbar">
        <div class="oh-filters-summary">
            <?php if (!empty($has_filters)): ?>
                <span class="oh-filter-badge">
                    <?php echo esc_html($total_items); ?> <?php honeypot_guard_e('results'); ?>
                    <?php if (!empty($active_filters)): ?>
                        (<?php echo esc_html(implode(', ', $active_filters)); ?>)
                    <?php endif; ?>
                </span>
            <?php else: ?>
                <span><?php echo esc_html($total_items); ?> <?php honeypot_guard_e('total_entries'); ?></span>
            <?php endif; ?>
        </div>
        <div class="oh-actions">
            <button type="button" class="button button-secondary" id="oh-clear-logs">
                <span class="dashicons dashicons-trash"></span> <?php honeypot_guard_e('clear_all_logs'); ?>
            </button>
            <button type="button" class="button button-secondary" id="oh-export-logs">
                <span class="dashicons dashicons-download"></span> <?php honeypot_guard_e('export_csv'); ?>
            </button>
        </div>
    </div>

    <div class="oh-card">
        <div class="oh-card-body oh-card-body-nopd">
            <?php if (empty($logs)): ?>
                <div class="oh-empty-state">
                    <span class="dashicons dashicons-clipboard"></span>
                    <p><?php honeypot_guard_e('no_logs_found'); ?></p>
                </div>
            <?php else: ?>
                <table class="oh-table oh-table-logs">
                    <thead>
                        <tr>
                            <th class="oh-col-status"><?php honeypot_guard_e('status'); ?></th>
                            <th class="oh-col-score"><?php honeypot_guard_e('score'); ?></th>
                            <th class="oh-col-reason"><?php honeypot_guard_e('reason'); ?></th>
                            <th class="oh-col-content"><?php honeypot_guard_e('content_preview'); ?></th>
                            <th class="oh-col-source"><?php honeypot_guard_e('source'); ?></th>
                            <th class="oh-col-url"><?php honeypot_guard_e('page_url'); ?></th>
                            <th class="oh-col-ip"><?php honeypot_guard_e('ip_address'); ?></th>
                            <th class="oh-col-time"><?php honeypot_guard_e('time'); ?></th>
                            <th class="oh-col-actions"><?php honeypot_guard_e('actions'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($logs as $log): ?>
                            <tr data-log-id="<?php echo esc_attr($log->id); ?>">
                                <td>
                                    <span class="oh-status oh-status-<?php echo esc_attr($log->status); ?>">
                                        <?php echo esc_html(ucfirst($log->status)); ?>
                                    </span>
                                </td>
                                <td>
                                    <span class="oh-score <?php echo $log->spam_score >= 70 ? 'high' : ($log->spam_score >= 40 ? 'medium' : 'low'); ?>">
                                        <?php echo esc_html($log->spam_score); ?>
                                    </span>
                                </td>
                                <td class="oh-reason">
                                    <?php echo esc_html($log->reason ?: 'No issues detected'); ?>
                                </td>
                                <td class="oh-content-preview">
                                    <?php
                                    $content = json_decode($log->content, true);
                                    if (is_array($content)) {
                                        $preview = '';
                                        foreach ($content as $key => $value) {
                                            if (strpos($key, '_oh_') === 0 || strpos($key, '_wp') === 0) continue;
                                            $val = is_array($value) ? implode(', ', $value) : $value;
                                            $preview .= sanitize_text_field($key) . ': ' . sanitize_text_field(substr($val, 0, 50)) . '... ';
                                            if (strlen($preview) > 100) break;
                                        }
                                        echo esc_html(substr($preview, 0, 150)) . (strlen($preview) > 150 ? '...' : '');
                                    } else {
                                        echo esc_html(substr($log->content, 0, 150)) . '...';
                                    }
                                    ?>
                                    <?php
                                    // Prepare content for modal - use base64 encoding for reliability
                                    $decoded_content = null;
                                    if (!empty($log->content)) {
                                        $decoded_content = json_decode($log->content, true);
                                        if ($decoded_content === null && json_last_error() !== JSON_ERROR_NONE) {
                                            // Not valid JSON, wrap it
                                            $decoded_content = ['_raw' => $log->content];
                                        }
                                    }
                                    // Encode to JSON then base64 for safe HTML attribute embedding
                                    $json_content = wp_json_encode($decoded_content ?: new stdClass());
                                    $base64_content = base64_encode($json_content);
                                    ?>
                                    <button type="button" class="button button-small oh-view-content"
                                            data-log-id="<?php echo esc_attr($log->id); ?>"
                                            data-content="<?php echo esc_attr($base64_content); ?>">
                                        View
                                    </button>
                                </td>
                                <td><?php echo esc_html($log->form_source); ?></td>
                                <td class="oh-url">
                                    <?php if (!empty($log->source_url)): ?>
                                        <a href="<?php echo esc_url($log->source_url); ?>" target="_blank" title="<?php echo esc_attr($log->source_url); ?>">
                                            <?php echo esc_html(mb_substr(wp_parse_url($log->source_url, PHP_URL_PATH) ?: $log->source_url, 0, 30)); ?>
                                            <?php echo strlen($log->source_url) > 30 ? '...' : ''; ?>
                                        </a>
                                    <?php else: ?>
                                        <span class="oh-na">-</span>
                                    <?php endif; ?>
                                </td>
                                <td class="oh-ip"><?php echo esc_html($log->ip_address); ?></td>
                                <td class="oh-time">
                                    <span title="<?php echo esc_attr($log->created_at); ?>">
                                        <?php echo esc_html(human_time_diff(strtotime($log->created_at), current_time('timestamp')) . ' ago'); ?>
                                    </span>
                                </td>
                                <td class="oh-actions-cell">
                                    <?php if (!empty($log->ip_address) && $log->ip_address !== 'unknown'):
                                        $is_ip_blocked = in_array(strtolower($log->ip_address), $blacklisted_ips);
                                    ?>
                                        <?php if ($is_ip_blocked): ?>
                                        <button type="button" class="button button-small oh-unblacklist-ip"
                                                title="<?php echo esc_attr(honeypot_guard_t('remove_ip_from_blacklist')); ?>"
                                                data-ip="<?php echo esc_attr($log->ip_address); ?>">
                                            <span class="dashicons dashicons-yes-alt"></span>
                                        </button>
                                        <?php else: ?>
                                        <button type="button" class="button button-small oh-blacklist-ip"
                                                title="<?php echo esc_attr(honeypot_guard_t('add_ip_to_blacklist')); ?>"
                                                data-ip="<?php echo esc_attr($log->ip_address); ?>">
                                            <span class="dashicons dashicons-dismiss"></span>
                                        </button>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <button type="button" class="button button-small oh-delete-log" title="<?php echo esc_attr(honeypot_guard_t('delete')); ?>">
                                        <span class="dashicons dashicons-trash"></span>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>

                <?php if ($total_pages > 1): ?>
                    <div class="oh-pagination">
                        <?php
                        // Build base URL with all current filters
                        $pagination_params = array_filter([
                            'page' => 'honeypot-guard-logs',
                            'status' => $status_filter ?? '',
                            'spam_type' => $spam_type_filter ?? '',
                            'char_filter' => $char_filter ?? '',
                            'form_source' => $form_source_filter ?? '',
                            'date_preset' => $date_preset ?? '',
                            'date_from' => $date_from ?? '',
                            'date_to' => $date_to ?? '',
                            'specific_date' => $specific_date ?? '',
                            'search' => $search_filter ?? '',
                        ]);
                        $base_url = admin_url('admin.php?' . http_build_query($pagination_params));

                        if ($current_page > 1): ?>
                            <a href="<?php echo esc_url($base_url . '&paged=' . ($current_page - 1)); ?>" class="button">&laquo; <?php honeypot_guard_e('previous'); ?></a>
                        <?php endif; ?>

                        <span class="oh-page-info"><?php honeypot_guard_e('page'); ?> <?php echo esc_html($current_page); ?> <?php honeypot_guard_e('of'); ?> <?php echo esc_html($total_pages); ?></span>

                        <?php if ($current_page < $total_pages): ?>
                            <a href="<?php echo esc_url($base_url . '&paged=' . ($current_page + 1)); ?>" class="button"><?php honeypot_guard_e('next'); ?> &raquo;</a>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>

    <div class="oh-footer">
        <p>
            <?php honeypot_guard_e('need_help'); ?>
            <a href="<?php echo esc_url($landing_url); ?>" target="_blank"><?php honeypot_guard_e('visit_website'); ?></a>
        </p>
    </div>
</div>

<!-- Content Modal -->
<div id="oh-content-modal" class="oh-modal" style="display:none;">
    <div class="oh-modal-content">
        <div class="oh-modal-header">
            <h3>Submission Content</h3>
            <button type="button" class="oh-modal-close">&times;</button>
        </div>
        <div class="oh-modal-body">
            <div id="oh-modal-content-display"></div>
        </div>
    </div>
</div>
