<?php
/**
 * HoneypotGuard Dashboard View
 *
 * @package HoneypotGuard
 */

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- View file variables are local scope

if (!defined('ABSPATH')) {
    exit;
}

$landing_url = honeypot_guard_url('landing_page');
$support_url = honeypot_guard_url('support');
?>

<div class="wrap honeypot-guard-wrap">
    <div class="oh-header">
        <h1>
            <span class="dashicons dashicons-shield-alt"></span>
            <?php echo esc_html(honeypot_guard_t('plugin_name') . ' ' . honeypot_guard_t('dashboard')); ?>
        </h1>
        <p class="oh-subtitle"><?php honeypot_guard_e('dashboard_subtitle'); ?></p>
    </div>

    <?php if ($show_escalation): ?>
    <div class="oh-escalation-banner">
        <div class="oh-escalation-content">
            <span class="dashicons dashicons-warning"></span>
            <div>
                <strong><?php honeypot_guard_e('high_spam_detected'); ?></strong>
                <p><?php echo esc_html(sprintf(honeypot_guard_t('spam_last_hour'), $spam_last_hour)); ?></p>
            </div>
            <a href="<?php echo esc_url($support_url); ?>" target="_blank" class="button button-primary oh-support-btn">
                <?php honeypot_guard_e('get_expert_support'); ?>
            </a>
        </div>
    </div>
    <?php endif; ?>

    <div class="oh-stats-grid">
        <div class="oh-stat-card oh-stat-blocked">
            <div class="oh-stat-icon">
                <span class="dashicons dashicons-dismiss"></span>
            </div>
            <div class="oh-stat-content">
                <span class="oh-stat-number"><?php echo esc_html($total_spam); ?></span>
                <span class="oh-stat-label"><?php honeypot_guard_e('total_blocked'); ?></span>
            </div>
        </div>

        <div class="oh-stat-card oh-stat-clean">
            <div class="oh-stat-icon">
                <span class="dashicons dashicons-yes-alt"></span>
            </div>
            <div class="oh-stat-content">
                <span class="oh-stat-number"><?php echo esc_html($total_clean); ?></span>
                <span class="oh-stat-label"><?php honeypot_guard_e('clean_submissions'); ?></span>
            </div>
        </div>

        <div class="oh-stat-card oh-stat-today">
            <div class="oh-stat-icon">
                <span class="dashicons dashicons-calendar-alt"></span>
            </div>
            <div class="oh-stat-content">
                <span class="oh-stat-number"><?php echo esc_html($spam_today); ?></span>
                <span class="oh-stat-label"><?php honeypot_guard_e('blocked_today'); ?></span>
            </div>
        </div>

        <div class="oh-stat-card oh-stat-rate">
            <div class="oh-stat-icon">
                <span class="dashicons dashicons-chart-pie"></span>
            </div>
            <div class="oh-stat-content">
                <?php
                $total = $total_spam + $total_clean;
                $rate = $total > 0 ? round(($total_spam / $total) * 100, 1) : 0;
                ?>
                <span class="oh-stat-number"><?php echo esc_html($rate); ?>%</span>
                <span class="oh-stat-label"><?php honeypot_guard_e('spam_rate'); ?></span>
            </div>
        </div>
    </div>

    <div class="oh-content-grid">
        <div class="oh-recent-activity">
            <div class="oh-card">
                <div class="oh-card-header">
                    <h2><?php honeypot_guard_e('recent_activity'); ?></h2>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=honeypot-guard-logs')); ?>" class="button"><?php honeypot_guard_e('view_all_logs'); ?></a>
                </div>
                <div class="oh-card-body">
                    <?php if (empty($recent_logs)): ?>
                        <div class="oh-empty-state">
                            <span class="dashicons dashicons-clipboard"></span>
                            <p><?php honeypot_guard_e('no_submissions_yet'); ?></p>
                        </div>
                    <?php else: ?>
                        <table class="oh-table">
                            <thead>
                                <tr>
                                    <th><?php honeypot_guard_e('status'); ?></th>
                                    <th><?php honeypot_guard_e('reason'); ?></th>
                                    <th><?php honeypot_guard_e('source'); ?></th>
                                    <th><?php honeypot_guard_e('time'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recent_logs as $log): ?>
                                    <tr>
                                        <td>
                                            <span class="oh-status oh-status-<?php echo esc_attr($log->status); ?>">
                                                <?php echo esc_html(ucfirst($log->status)); ?>
                                            </span>
                                        </td>
                                        <td class="oh-reason">
                                            <?php echo esc_html($log->reason ?: 'N/A'); ?>
                                        </td>
                                        <td><?php echo esc_html($log->form_source); ?></td>
                                        <td class="oh-time">
                                            <?php echo esc_html(human_time_diff(strtotime($log->created_at), current_time('timestamp')) . ' ' . honeypot_guard_t('ago')); ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="oh-sidebar">
            <div class="oh-card oh-quick-settings">
                <div class="oh-card-header">
                    <h2><?php honeypot_guard_e('protection_status'); ?></h2>
                </div>
                <div class="oh-card-body">
                    <?php $opts = get_option('honeypot_guard_options', []); ?>
                    <ul class="oh-status-list">
                        <li class="<?php echo !empty($opts['honeypot_enabled']) ? 'active' : 'inactive'; ?>">
                            <span class="dashicons <?php echo !empty($opts['honeypot_enabled']) ? 'dashicons-yes' : 'dashicons-no'; ?>"></span>
                            <?php honeypot_guard_e('honeypot_protection'); ?>
                        </li>
                        <li class="<?php echo !empty($opts['timestamp_enabled']) ? 'active' : 'inactive'; ?>">
                            <span class="dashicons <?php echo !empty($opts['timestamp_enabled']) ? 'dashicons-yes' : 'dashicons-no'; ?>"></span>
                            <?php honeypot_guard_e('timestamp_protection'); ?>
                        </li>
                        <li class="<?php echo !empty($opts['heuristic_enabled']) ? 'active' : 'inactive'; ?>">
                            <span class="dashicons <?php echo !empty($opts['heuristic_enabled']) ? 'dashicons-yes' : 'dashicons-no'; ?>"></span>
                            <?php honeypot_guard_e('heuristic_analysis'); ?>
                        </li>
                        <li class="<?php echo !empty($opts['cyrillic_filter']) ? 'active' : 'inactive'; ?>">
                            <span class="dashicons <?php echo !empty($opts['cyrillic_filter']) ? 'dashicons-yes' : 'dashicons-no'; ?>"></span>
                            <?php honeypot_guard_e('block_cyrillic'); ?>
                        </li>
                        <li class="<?php echo !empty($opts['hanzi_filter']) ? 'active' : 'inactive'; ?>">
                            <span class="dashicons <?php echo !empty($opts['hanzi_filter']) ? 'dashicons-yes' : 'dashicons-no'; ?>"></span>
                            <?php honeypot_guard_e('block_chinese'); ?>
                        </li>
                    </ul>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=honeypot-guard-settings')); ?>" class="button button-secondary" style="width:100%;text-align:center;margin-top:15px;">
                        <?php honeypot_guard_e('settings'); ?>
                    </a>
                </div>
            </div>

            <div class="oh-card oh-integration-status">
                <div class="oh-card-header">
                    <h2><?php honeypot_guard_e('integrations'); ?></h2>
                </div>
                <div class="oh-card-body">
                    <ul class="oh-status-list">
                        <li class="<?php echo class_exists('WPCF7') ? 'active' : 'inactive'; ?>">
                            <span class="dashicons <?php echo class_exists('WPCF7') ? 'dashicons-yes' : 'dashicons-minus'; ?>"></span>
                            <?php honeypot_guard_e('contact_form_7'); ?>
                            <span class="oh-int-status"><?php echo esc_html(class_exists('WPCF7') ? honeypot_guard_t('connected') : honeypot_guard_t('not_detected')); ?></span>
                        </li>
                        <li class="active">
                            <span class="dashicons dashicons-yes"></span>
                            <?php honeypot_guard_e('generic_forms'); ?>
                            <span class="oh-int-status"><?php honeypot_guard_e('active'); ?></span>
                        </li>
                        <li class="active">
                            <span class="dashicons dashicons-yes"></span>
                            <?php honeypot_guard_e('rest_api'); ?>
                            <span class="oh-int-status"><?php honeypot_guard_e('ready'); ?></span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="oh-footer">
        <p>
            <?php honeypot_guard_e('need_help'); ?>
            <a href="<?php echo esc_url($landing_url); ?>" target="_blank"><?php honeypot_guard_e('visit_website'); ?></a>
        </p>
    </div>
</div>
