<?php
/**
 * HoneypotGuard Blacklist Management View
 *
 * @package HoneypotGuard
 */

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- View file variables are local scope

if (!defined('ABSPATH')) {
    exit;
}

$landing_url = honeypot_guard_url('landing_page');
?>

<div class="wrap honeypot-guard-wrap">
    <div class="oh-header">
        <h1>
            <span class="dashicons dashicons-shield-alt"></span>
            <?php honeypot_guard_e('blacklist_management'); ?>
        </h1>
        <p class="oh-subtitle"><?php honeypot_guard_e('blacklist_subtitle'); ?></p>
    </div>

    <div class="oh-blacklist-actions">
        <div class="oh-add-form">
            <select id="oh-bl-type">
                <option value="email"><?php honeypot_guard_e('email_type'); ?></option>
                <option value="domain"><?php honeypot_guard_e('domain_type'); ?></option>
                <option value="ip"><?php honeypot_guard_e('ip_address_type'); ?></option>
                <option value="keyword"><?php honeypot_guard_e('keyword_type'); ?></option>
            </select>
            <input type="text" id="oh-bl-value" placeholder="<?php echo esc_attr(honeypot_guard_t('value_to_block')); ?>" class="regular-text">
            <input type="text" id="oh-bl-reason" placeholder="<?php echo esc_attr(honeypot_guard_t('reason_optional')); ?>" class="regular-text">
            <button type="button" id="oh-add-blacklist" class="button button-primary">
                <span class="dashicons dashicons-plus-alt2"></span>
                <?php honeypot_guard_e('add_to_blacklist'); ?>
            </button>
        </div>
    </div>

    <div class="oh-card">
        <div class="oh-card-header">
            <h2><?php honeypot_guard_e('active_blacklist_entries'); ?></h2>
            <span class="oh-entry-count"><?php echo count($entries); ?> <?php honeypot_guard_e('entries'); ?></span>
        </div>
        <div class="oh-card-body oh-card-body-nopd">
            <?php if (empty($entries)): ?>
                <div class="oh-empty-state">
                    <span class="dashicons dashicons-clipboard"></span>
                    <p><?php honeypot_guard_e('no_blacklist_entries'); ?></p>
                </div>
            <?php else: ?>
                <table class="oh-table oh-table-blacklist">
                    <thead>
                        <tr>
                            <th class="oh-col-type"><?php honeypot_guard_e('type'); ?></th>
                            <th class="oh-col-value"><?php honeypot_guard_e('value'); ?></th>
                            <th class="oh-col-reason"><?php honeypot_guard_e('reason'); ?></th>
                            <th class="oh-col-hits"><?php honeypot_guard_e('hits'); ?></th>
                            <th class="oh-col-date"><?php honeypot_guard_e('added'); ?></th>
                            <th class="oh-col-actions"><?php honeypot_guard_e('actions'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($entries as $entry): ?>
                            <tr data-id="<?php echo esc_attr($entry->id); ?>">
                                <td>
                                    <span class="oh-type-badge oh-type-<?php echo esc_attr($entry->type); ?>">
                                        <?php echo esc_html(ucfirst($entry->type)); ?>
                                    </span>
                                </td>
                                <td class="oh-value">
                                    <code><?php echo esc_html($entry->value); ?></code>
                                </td>
                                <td class="oh-reason">
                                    <?php echo esc_html($entry->reason ?: '-'); ?>
                                </td>
                                <td class="oh-hits">
                                    <span class="oh-hit-count <?php echo $entry->hits > 0 ? 'has-hits' : ''; ?>">
                                        <?php echo esc_html($entry->hits); ?>
                                    </span>
                                </td>
                                <td class="oh-date">
                                    <?php echo esc_html(human_time_diff(strtotime($entry->created_at), current_time('timestamp')) . ' ' . honeypot_guard_t('ago')); ?>
                                </td>
                                <td class="oh-actions-cell">
                                    <button type="button" class="button button-small oh-remove-blacklist" title="<?php echo esc_attr(honeypot_guard_t('remove')); ?>">
                                        <span class="dashicons dashicons-trash"></span>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>

    <div class="oh-info-box">
        <h3><?php honeypot_guard_e('quick_tips'); ?></h3>
        <ul>
            <li><strong><?php honeypot_guard_e('email_type'); ?>:</strong> <?php honeypot_guard_e('tip_email'); ?></li>
            <li><strong><?php honeypot_guard_e('domain_type'); ?>:</strong> <?php honeypot_guard_e('tip_domain'); ?></li>
            <li><strong><?php honeypot_guard_e('ip_address_type'); ?>:</strong> <?php honeypot_guard_e('tip_ip'); ?></li>
            <li><strong><?php honeypot_guard_e('keyword_type'); ?>:</strong> <?php honeypot_guard_e('tip_keyword'); ?></li>
        </ul>
    </div>

    <div class="oh-footer">
        <p>
            <?php honeypot_guard_e('need_help'); ?>
            <a href="<?php echo esc_url($landing_url); ?>" target="_blank"><?php honeypot_guard_e('visit_website'); ?></a>
        </p>
    </div>
</div>
