<?php
/**
 * Honeypot Guard Translations
 *
 * Provides multilingual support for the admin interface.
 * Languages: English, Lithuanian, Italian, German, Spanish (Mexico), Spanish, Swedish, Polish, Estonian
 *
 * @package HoneypotGuard
 */

if (!defined('ABSPATH')) {
    exit;
}

class HoneypotGuard_Translations {

    private static $instance = null;
    private $current_language = 'en';
    private $translations = [];

    /**
     * Available languages
     */
    public static $languages = [
        'en' => 'English',
        'lt' => 'Lietuvių',
        'it' => 'Italiano',
        'de' => 'Deutsch',
        'es_MX' => 'Español (México)',
        'es' => 'Español',
        'sv' => 'Svenska',
        'pl' => 'Polski',
        'et' => 'Eesti'
    ];

    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        $this->load_translations();
    }

    public function set_language($lang) {
        if (isset(self::$languages[$lang])) {
            $this->current_language = $lang;
        }
    }

    public function get_language() {
        return $this->current_language;
    }

    public function t($key) {
        if (isset($this->translations[$key][$this->current_language])) {
            return $this->translations[$key][$this->current_language];
        }
        // Fallback to English
        if (isset($this->translations[$key]['en'])) {
            return $this->translations[$key]['en'];
        }
        return $key;
    }

    /**
     * Get URL based on current language
     */
    public function url($key) {
        $urls = [
            'landing_page' => [
                'en' => 'https://www.mantasdigital.com/honeypot-guard/',
                'lt' => 'https://www.md.lt/honeypot-guard/',
            ],
            'support' => [
                'en' => 'https://www.mantasdigital.com/',
                'lt' => 'https://md.lt/',
            ],
        ];

        if (isset($urls[$key][$this->current_language])) {
            return $urls[$key][$this->current_language];
        }
        // Fallback to English
        if (isset($urls[$key]['en'])) {
            return $urls[$key]['en'];
        }
        return '';
    }

    private function load_translations() {
        $this->translations = [
            // =====================================================
            // GENERAL / NAVIGATION
            // =====================================================
            'plugin_name' => [
                'en' => 'Honeypot Guard',
                'lt' => 'Honeypot Guard',
                'it' => 'Honeypot Guard',
                'de' => 'Honeypot Guard',
                'es_MX' => 'Honeypot Guard',
                'es' => 'Honeypot Guard',
                'sv' => 'Honeypot Guard',
                'pl' => 'Honeypot Guard',
                'et' => 'Honeypot Guard'
            ],
            'dashboard' => [
                'en' => 'Dashboard',
                'lt' => 'Valdymo skydelis',
                'it' => 'Pannello di controllo',
                'de' => 'Dashboard',
                'es_MX' => 'Panel de control',
                'es' => 'Panel de control',
                'sv' => 'Instrumentpanel',
                'pl' => 'Panel',
                'et' => 'Töölaud'
            ],
            'settings' => [
                'en' => 'Settings',
                'lt' => 'Nustatymai',
                'it' => 'Impostazioni',
                'de' => 'Einstellungen',
                'es_MX' => 'Configuración',
                'es' => 'Configuración',
                'sv' => 'Inställningar',
                'pl' => 'Ustawienia',
                'et' => 'Seaded'
            ],
            'blacklists' => [
                'en' => 'Blacklists',
                'lt' => 'Juodieji sąrašai',
                'it' => 'Liste nere',
                'de' => 'Sperrlisten',
                'es_MX' => 'Listas negras',
                'es' => 'Listas negras',
                'sv' => 'Svartlistor',
                'pl' => 'Czarne listy',
                'et' => 'Mustad nimekirjad'
            ],
            'spam_logs' => [
                'en' => 'Spam Logs',
                'lt' => 'Šlamšto žurnalai',
                'it' => 'Registri spam',
                'de' => 'Spam-Protokolle',
                'es_MX' => 'Registros de spam',
                'es' => 'Registros de spam',
                'sv' => 'Skräppostloggar',
                'pl' => 'Dzienniki spamu',
                'et' => 'Rämpsposti logid'
            ],
            'save_settings' => [
                'en' => 'Save Settings',
                'lt' => 'Išsaugoti nustatymus',
                'it' => 'Salva impostazioni',
                'de' => 'Einstellungen speichern',
                'es_MX' => 'Guardar configuración',
                'es' => 'Guardar configuración',
                'sv' => 'Spara inställningar',
                'pl' => 'Zapisz ustawienia',
                'et' => 'Salvesta seaded'
            ],

            // =====================================================
            // DASHBOARD
            // =====================================================
            'dashboard_subtitle' => [
                'en' => 'Intelligent Spam Protection for WordPress',
                'lt' => 'Išmanioji šlamšto apsauga WordPress sistemai',
                'it' => 'Protezione intelligente dallo spam per WordPress',
                'de' => 'Intelligenter Spam-Schutz für WordPress',
                'es_MX' => 'Protección inteligente contra spam para WordPress',
                'es' => 'Protección inteligente contra spam para WordPress',
                'sv' => 'Intelligent skräppostskydd för WordPress',
                'pl' => 'Inteligentna ochrona przed spamem dla WordPress',
                'et' => 'Intelligentne rämpsposti kaitse WordPressile'
            ],
            'total_blocked' => [
                'en' => 'Total Blocked',
                'lt' => 'Iš viso užblokuota',
                'it' => 'Totale bloccati',
                'de' => 'Gesamt blockiert',
                'es_MX' => 'Total bloqueados',
                'es' => 'Total bloqueados',
                'sv' => 'Totalt blockerade',
                'pl' => 'Łącznie zablokowano',
                'et' => 'Kokku blokeeritud'
            ],
            'clean_submissions' => [
                'en' => 'Clean Submissions',
                'lt' => 'Švarūs pateikimai',
                'it' => 'Invii puliti',
                'de' => 'Saubere Einreichungen',
                'es_MX' => 'Envíos limpios',
                'es' => 'Envíos limpios',
                'sv' => 'Rena inskickningar',
                'pl' => 'Czyste zgłoszenia',
                'et' => 'Puhtad esitused'
            ],
            'blocked_today' => [
                'en' => 'Blocked Today',
                'lt' => 'Šiandien užblokuota',
                'it' => 'Bloccati oggi',
                'de' => 'Heute blockiert',
                'es_MX' => 'Bloqueados hoy',
                'es' => 'Bloqueados hoy',
                'sv' => 'Blockerade idag',
                'pl' => 'Zablokowano dziś',
                'et' => 'Täna blokeeritud'
            ],
            'spam_rate' => [
                'en' => 'Spam Rate',
                'lt' => 'Šlamšto dažnis',
                'it' => 'Tasso di spam',
                'de' => 'Spam-Rate',
                'es_MX' => 'Tasa de spam',
                'es' => 'Tasa de spam',
                'sv' => 'Skräppostfrekvens',
                'pl' => 'Współczynnik spamu',
                'et' => 'Rämpsposti määr'
            ],
            'recent_activity' => [
                'en' => 'Recent Activity',
                'lt' => 'Naujausia veikla',
                'it' => 'Attività recente',
                'de' => 'Letzte Aktivität',
                'es_MX' => 'Actividad reciente',
                'es' => 'Actividad reciente',
                'sv' => 'Senaste aktivitet',
                'pl' => 'Ostatnia aktywność',
                'et' => 'Viimane tegevus'
            ],
            'view_all_logs' => [
                'en' => 'View All Logs',
                'lt' => 'Peržiūrėti visus žurnalus',
                'it' => 'Visualizza tutti i registri',
                'de' => 'Alle Protokolle anzeigen',
                'es_MX' => 'Ver todos los registros',
                'es' => 'Ver todos los registros',
                'sv' => 'Visa alla loggar',
                'pl' => 'Zobacz wszystkie logi',
                'et' => 'Vaata kõiki logisid'
            ],
            'no_submissions_yet' => [
                'en' => 'No submissions recorded yet. Honeypot Guard is active and monitoring your forms.',
                'lt' => 'Dar nėra įrašytų pateikimų. Honeypot Guard yra aktyvus ir stebi jūsų formas.',
                'it' => 'Nessun invio registrato. Honeypot Guard è attivo e sta monitorando i tuoi moduli.',
                'de' => 'Noch keine Einreichungen erfasst. Honeypot Guard ist aktiv und überwacht Ihre Formulare.',
                'es_MX' => 'Aún no hay envíos registrados. Honeypot Guard está activo y monitoreando tus formularios.',
                'es' => 'Aún no hay envíos registrados. Honeypot Guard está activo y monitoreando tus formularios.',
                'sv' => 'Inga inskickningar registrerade ännu. Honeypot Guard är aktiv och övervakar dina formulär.',
                'pl' => 'Brak zarejestrowanych zgłoszeń. Honeypot Guard jest aktywny i monitoruje Twoje formularze.',
                'et' => 'Esitusi pole veel salvestatud. Honeypot Guard on aktiivne ja jälgib teie vorme.'
            ],
            'protection_status' => [
                'en' => 'Protection Status',
                'lt' => 'Apsaugos būsena',
                'it' => 'Stato protezione',
                'de' => 'Schutzstatus',
                'es_MX' => 'Estado de protección',
                'es' => 'Estado de protección',
                'sv' => 'Skyddsstatus',
                'pl' => 'Stan ochrony',
                'et' => 'Kaitse olek'
            ],
            'high_spam_detected' => [
                'en' => 'High Spam Activity Detected',
                'lt' => 'Aptikta didelė šlamšto veikla',
                'it' => 'Rilevata alta attività di spam',
                'de' => 'Hohe Spam-Aktivität erkannt',
                'es_MX' => 'Alta actividad de spam detectada',
                'es' => 'Alta actividad de spam detectada',
                'sv' => 'Hög skräppostaktivitet upptäckt',
                'pl' => 'Wykryto wysoką aktywność spamu',
                'et' => 'Tuvastati kõrge rämpsposti aktiivsus'
            ],
            'spam_last_hour' => [
                'en' => 'You\'ve received %d spam submissions in the last hour. Need professional help?',
                'lt' => 'Per pastarąją valandą gavote %d šlamšto pateikimų. Reikia profesionalios pagalbos?',
                'it' => 'Hai ricevuto %d invii spam nell\'ultima ora. Hai bisogno di aiuto professionale?',
                'de' => 'Sie haben in der letzten Stunde %d Spam-Einreichungen erhalten. Brauchen Sie professionelle Hilfe?',
                'es_MX' => 'Has recibido %d envíos de spam en la última hora. ¿Necesitas ayuda profesional?',
                'es' => 'Has recibido %d envíos de spam en la última hora. ¿Necesitas ayuda profesional?',
                'sv' => 'Du har fått %d skräppostinskickningar den senaste timmen. Behöver du professionell hjälp?',
                'pl' => 'Otrzymałeś %d zgłoszeń spamu w ciągu ostatniej godziny. Potrzebujesz profesjonalnej pomocy?',
                'et' => 'Olete viimase tunni jooksul saanud %d rämpsposti esitust. Vajate professionaalset abi?'
            ],
            'get_expert_support' => [
                'en' => 'Get Expert Support',
                'lt' => 'Gauti eksperto pagalbą',
                'it' => 'Ottieni supporto esperto',
                'de' => 'Experten-Support erhalten',
                'es_MX' => 'Obtener soporte experto',
                'es' => 'Obtener soporte experto',
                'sv' => 'Få expertstöd',
                'pl' => 'Uzyskaj wsparcie eksperta',
                'et' => 'Saa eksperdi tuge'
            ],

            // =====================================================
            // SETTINGS PAGE
            // =====================================================
            'settings_title' => [
                'en' => 'Honeypot Guard Settings',
                'lt' => 'Honeypot Guard nustatymai',
                'it' => 'Impostazioni Honeypot Guard',
                'de' => 'Honeypot Guard-Einstellungen',
                'es_MX' => 'Configuración de Honeypot Guard',
                'es' => 'Configuración de Honeypot Guard',
                'sv' => 'Honeypot Guard-inställningar',
                'pl' => 'Ustawienia Honeypot Guard',
                'et' => 'Honeypot Guard seaded'
            ],
            'settings_subtitle' => [
                'en' => 'Configure your spam protection preferences',
                'lt' => 'Konfigūruokite savo šlamšto apsaugos nuostatas',
                'it' => 'Configura le tue preferenze di protezione spam',
                'de' => 'Konfigurieren Sie Ihre Spam-Schutz-Einstellungen',
                'es_MX' => 'Configura tus preferencias de protección contra spam',
                'es' => 'Configura tus preferencias de protección contra spam',
                'sv' => 'Konfigurera dina skräppostskyddsinställningar',
                'pl' => 'Skonfiguruj preferencje ochrony przed spamem',
                'et' => 'Seadistage oma rämpsposti kaitse eelistused'
            ],
            'language_setting' => [
                'en' => 'Interface Language',
                'lt' => 'Sąsajos kalba',
                'it' => 'Lingua interfaccia',
                'de' => 'Oberflächensprache',
                'es_MX' => 'Idioma de interfaz',
                'es' => 'Idioma de interfaz',
                'sv' => 'Gränssnittsspråk',
                'pl' => 'Język interfejsu',
                'et' => 'Liidese keel'
            ],
            'language_description' => [
                'en' => 'Select the language for the admin interface.',
                'lt' => 'Pasirinkite administravimo sąsajos kalbą.',
                'it' => 'Seleziona la lingua per l\'interfaccia di amministrazione.',
                'de' => 'Wählen Sie die Sprache für die Admin-Oberfläche.',
                'es_MX' => 'Selecciona el idioma para la interfaz de administración.',
                'es' => 'Selecciona el idioma para la interfaz de administración.',
                'sv' => 'Välj språk för administratörsgränssnittet.',
                'pl' => 'Wybierz język interfejsu administratora.',
                'et' => 'Valige administreerimisliidese keel.'
            ],

            // Honeypot Settings
            'honeypot_protection' => [
                'en' => 'Honeypot Protection',
                'lt' => 'Honeypot apsauga',
                'it' => 'Protezione Honeypot',
                'de' => 'Honeypot-Schutz',
                'es_MX' => 'Protección Honeypot',
                'es' => 'Protección Honeypot',
                'sv' => 'Honeypot-skydd',
                'pl' => 'Ochrona Honeypot',
                'et' => 'Honeypot kaitse'
            ],
            'enable_honeypot' => [
                'en' => 'Enable Honeypot Field',
                'lt' => 'Įjungti Honeypot lauką',
                'it' => 'Abilita campo Honeypot',
                'de' => 'Honeypot-Feld aktivieren',
                'es_MX' => 'Habilitar campo Honeypot',
                'es' => 'Habilitar campo Honeypot',
                'sv' => 'Aktivera Honeypot-fält',
                'pl' => 'Włącz pole Honeypot',
                'et' => 'Luba Honeypot väli'
            ],
            'honeypot_description' => [
                'en' => 'Adds invisible fields that trap bots.',
                'lt' => 'Prideda nematomus laukus, kurie spąstuoja botus.',
                'it' => 'Aggiunge campi invisibili che intrappolano i bot.',
                'de' => 'Fügt unsichtbare Felder hinzu, die Bots fangen.',
                'es_MX' => 'Agrega campos invisibles que atrapan bots.',
                'es' => 'Agrega campos invisibles que atrapan bots.',
                'sv' => 'Lägger till osynliga fält som fångar botar.',
                'pl' => 'Dodaje niewidoczne pola, które łapią boty.',
                'et' => 'Lisab nähtamatud väljad, mis püüavad roboteid.'
            ],
            'field_name_mode' => [
                'en' => 'Field Name Mode',
                'lt' => 'Lauko pavadinimo režimas',
                'it' => 'Modalità nome campo',
                'de' => 'Feldnamen-Modus',
                'es_MX' => 'Modo de nombre de campo',
                'es' => 'Modo de nombre de campo',
                'sv' => 'Fältnamnläge',
                'pl' => 'Tryb nazwy pola',
                'et' => 'Väljanime režiim'
            ],
            'mode_auto' => [
                'en' => 'Auto (Site-based)',
                'lt' => 'Automatinis (pagal svetainę)',
                'it' => 'Automatico (basato sul sito)',
                'de' => 'Automatisch (Site-basiert)',
                'es_MX' => 'Automático (basado en el sitio)',
                'es' => 'Automático (basado en el sitio)',
                'sv' => 'Automatisk (webbplatsbaserad)',
                'pl' => 'Automatyczny (na podstawie witryny)',
                'et' => 'Automaatne (saidi põhine)'
            ],
            'mode_dynamic' => [
                'en' => 'Dynamic (Rotating)',
                'lt' => 'Dinaminis (kintantis)',
                'it' => 'Dinamico (rotazione)',
                'de' => 'Dynamisch (rotierend)',
                'es_MX' => 'Dinámico (rotativo)',
                'es' => 'Dinámico (rotativo)',
                'sv' => 'Dynamisk (roterande)',
                'pl' => 'Dynamiczny (rotacyjny)',
                'et' => 'Dünaamiline (pöörlev)'
            ],
            'mode_custom' => [
                'en' => 'Custom (Fixed)',
                'lt' => 'Pasirinktinis (fiksuotas)',
                'it' => 'Personalizzato (fisso)',
                'de' => 'Benutzerdefiniert (fest)',
                'es_MX' => 'Personalizado (fijo)',
                'es' => 'Personalizado (fijo)',
                'sv' => 'Anpassad (fast)',
                'pl' => 'Niestandardowy (stały)',
                'et' => 'Kohandatud (fikseeritud)'
            ],
            'mode_description' => [
                'en' => 'Auto: consistent per site. Dynamic: rotates to confuse bots. Custom: you choose.',
                'lt' => 'Auto: nuoseklus svetainei. Dinaminis: keičiasi, kad suklaidintų botus. Pasirinktinis: jūs pasirenkate.',
                'it' => 'Auto: coerente per sito. Dinamico: ruota per confondere i bot. Personalizzato: scegli tu.',
                'de' => 'Auto: konsistent pro Site. Dynamisch: rotiert, um Bots zu verwirren. Benutzerdefiniert: Sie wählen.',
                'es_MX' => 'Auto: consistente por sitio. Dinámico: rota para confundir bots. Personalizado: tú eliges.',
                'es' => 'Auto: consistente por sitio. Dinámico: rota para confundir bots. Personalizado: tú eliges.',
                'sv' => 'Auto: konsekvent per webbplats. Dynamisk: roterar för att förvirra botar. Anpassad: du väljer.',
                'pl' => 'Auto: spójny dla witryny. Dynamiczny: rotuje, aby zmylić boty. Niestandardowy: Ty wybierasz.',
                'et' => 'Auto: järjepidev saidi kohta. Dünaamiline: pöörleb robotite segamiseks. Kohandatud: teie valite.'
            ],
            'rotation_frequency' => [
                'en' => 'Rotation Frequency',
                'lt' => 'Keitimo dažnumas',
                'it' => 'Frequenza di rotazione',
                'de' => 'Rotationshäufigkeit',
                'es_MX' => 'Frecuencia de rotación',
                'es' => 'Frecuencia de rotación',
                'sv' => 'Rotationsfrekvens',
                'pl' => 'Częstotliwość rotacji',
                'et' => 'Pöörlemissagedus'
            ],
            'per_visitor_session' => [
                'en' => 'Per Visitor Session',
                'lt' => 'Kiekvienam lankytojo seansui',
                'it' => 'Per sessione visitatore',
                'de' => 'Pro Besuchersitzung',
                'es_MX' => 'Por sesión de visitante',
                'es' => 'Por sesión de visitante',
                'sv' => 'Per besökarsession',
                'pl' => 'Na sesję odwiedzającego',
                'et' => 'Külastaja seansi kohta'
            ],
            'hourly' => [
                'en' => 'Hourly',
                'lt' => 'Kas valandą',
                'it' => 'Ogni ora',
                'de' => 'Stündlich',
                'es_MX' => 'Cada hora',
                'es' => 'Cada hora',
                'sv' => 'Varje timme',
                'pl' => 'Co godzinę',
                'et' => 'Tunni kaupa'
            ],
            'daily' => [
                'en' => 'Daily',
                'lt' => 'Kasdien',
                'it' => 'Giornaliero',
                'de' => 'Täglich',
                'es_MX' => 'Diario',
                'es' => 'Diario',
                'sv' => 'Dagligen',
                'pl' => 'Codziennie',
                'et' => 'Igapäevane'
            ],
            'custom_field_name' => [
                'en' => 'Custom Field Name',
                'lt' => 'Pasirinktinis lauko pavadinimas',
                'it' => 'Nome campo personalizzato',
                'de' => 'Benutzerdefinierter Feldname',
                'es_MX' => 'Nombre de campo personalizado',
                'es' => 'Nombre de campo personalizado',
                'sv' => 'Anpassat fältnamn',
                'pl' => 'Niestandardowa nazwa pola',
                'et' => 'Kohandatud välja nimi'
            ],
            'additional_field_names' => [
                'en' => 'Additional Field Names (one per line)',
                'lt' => 'Papildomi laukų pavadinimai (po vieną eilutėje)',
                'it' => 'Nomi campi aggiuntivi (uno per riga)',
                'de' => 'Zusätzliche Feldnamen (einer pro Zeile)',
                'es_MX' => 'Nombres de campo adicionales (uno por línea)',
                'es' => 'Nombres de campo adicionales (uno por línea)',
                'sv' => 'Ytterligare fältnamn (ett per rad)',
                'pl' => 'Dodatkowe nazwy pól (jedna na linię)',
                'et' => 'Täiendavad väljade nimed (üks rea kohta)'
            ],
            'additional_names_description' => [
                'en' => 'Add your own realistic field names to the rotation pool.',
                'lt' => 'Pridėkite savo realistiškus laukų pavadinimus į keitimo fondą.',
                'it' => 'Aggiungi i tuoi nomi di campo realistici al pool di rotazione.',
                'de' => 'Fügen Sie Ihre eigenen realistischen Feldnamen zum Rotationspool hinzu.',
                'es_MX' => 'Agrega tus propios nombres de campo realistas al grupo de rotación.',
                'es' => 'Agrega tus propios nombres de campo realistas al grupo de rotación.',
                'sv' => 'Lägg till dina egna realistiska fältnamn i rotationspoolen.',
                'pl' => 'Dodaj własne realistyczne nazwy pól do puli rotacji.',
                'et' => 'Lisage oma realistlikud väljanimed pöörlusfondi.'
            ],
            'inject_via_js' => [
                'en' => 'Inject via JavaScript',
                'lt' => 'Įterpti per JavaScript',
                'it' => 'Inietta tramite JavaScript',
                'de' => 'Über JavaScript einfügen',
                'es_MX' => 'Inyectar vía JavaScript',
                'es' => 'Inyectar vía JavaScript',
                'sv' => 'Injicera via JavaScript',
                'pl' => 'Wstrzyknij przez JavaScript',
                'et' => 'Sisesta JavaScripti kaudu'
            ],
            'inject_js_description' => [
                'en' => 'Adds honeypot via JS (harder for bots). Disable if strict CSP.',
                'lt' => 'Prideda honeypot per JS (sunkiau botams). Išjunkite, jei griežtas CSP.',
                'it' => 'Aggiunge honeypot tramite JS (più difficile per i bot). Disabilita se CSP rigido.',
                'de' => 'Fügt Honeypot per JS hinzu (schwerer für Bots). Deaktivieren bei striktem CSP.',
                'es_MX' => 'Agrega honeypot vía JS (más difícil para bots). Desactiva si tienes CSP estricto.',
                'es' => 'Agrega honeypot vía JS (más difícil para bots). Desactiva si tienes CSP estricto.',
                'sv' => 'Lägger till honeypot via JS (svårare för botar). Inaktivera om strikt CSP.',
                'pl' => 'Dodaje honeypot przez JS (trudniejsze dla botów). Wyłącz przy ścisłym CSP.',
                'et' => 'Lisab honeypoti JS-i kaudu (robotitele raskem). Keelake range CSP korral.'
            ],
            'multiple_honeypots' => [
                'en' => 'Multiple Honeypot Fields',
                'lt' => 'Keli Honeypot laukai',
                'it' => 'Campi Honeypot multipli',
                'de' => 'Mehrere Honeypot-Felder',
                'es_MX' => 'Múltiples campos Honeypot',
                'es' => 'Múltiples campos Honeypot',
                'sv' => 'Flera Honeypot-fält',
                'pl' => 'Wiele pól Honeypot',
                'et' => 'Mitu Honeypot välja'
            ],
            'multiple_honeypots_description' => [
                'en' => 'Adds 2-3 honeypot fields per form for extra protection.',
                'lt' => 'Prideda 2-3 honeypot laukus kiekvienai formai papildomai apsaugai.',
                'it' => 'Aggiunge 2-3 campi honeypot per modulo per protezione extra.',
                'de' => 'Fügt 2-3 Honeypot-Felder pro Formular für zusätzlichen Schutz hinzu.',
                'es_MX' => 'Agrega 2-3 campos honeypot por formulario para protección extra.',
                'es' => 'Agrega 2-3 campos honeypot por formulario para protección extra.',
                'sv' => 'Lägger till 2-3 honeypot-fält per formulär för extra skydd.',
                'pl' => 'Dodaje 2-3 pola honeypot na formularz dla dodatkowej ochrony.',
                'et' => 'Lisab 2-3 honeypot välja vormi kohta täiendavaks kaitseks.'
            ],

            // Registration Form Protection
            'registration_protection' => [
                'en' => 'Registration Protection',
                'lt' => 'Registracijos apsauga',
                'it' => 'Protezione registrazione',
                'de' => 'Registrierungsschutz',
                'es_MX' => 'Protección de registro',
                'es' => 'Protección de registro',
                'sv' => 'Registreringsskydd',
                'pl' => 'Ochrona rejestracji',
                'et' => 'Registreerimise kaitse'
            ],
            'enable_registration_protection' => [
                'en' => 'Protect Registration Forms',
                'lt' => 'Apsaugoti registracijos formas',
                'it' => 'Proteggi moduli di registrazione',
                'de' => 'Registrierungsformulare schützen',
                'es_MX' => 'Proteger formularios de registro',
                'es' => 'Proteger formularios de registro',
                'sv' => 'Skydda registreringsformulär',
                'pl' => 'Chroń formularze rejestracji',
                'et' => 'Kaitse registreerimisvorme'
            ],
            'registration_protection_description' => [
                'en' => 'Adds honeypot protection to WordPress and WooCommerce registration forms. When enabled, conversion events will only fire after successful spam-free registration.',
                'lt' => 'Prideda honeypot apsaugą WordPress ir WooCommerce registracijos formoms. Įjungus, konversijos įvykiai bus suaktyvinami tik po sėkmingos registracijos be šlamšto.',
                'it' => 'Aggiunge protezione honeypot ai moduli di registrazione WordPress e WooCommerce. Se abilitato, gli eventi di conversione verranno attivati solo dopo una registrazione senza spam.',
                'de' => 'Fügt Honeypot-Schutz zu WordPress- und WooCommerce-Registrierungsformularen hinzu. Bei Aktivierung werden Conversion-Events nur nach erfolgreicher spam-freier Registrierung ausgelöst.',
                'es_MX' => 'Agrega protección honeypot a los formularios de registro de WordPress y WooCommerce. Cuando está habilitado, los eventos de conversión solo se dispararán después de un registro exitoso sin spam.',
                'es' => 'Agrega protección honeypot a los formularios de registro de WordPress y WooCommerce. Cuando está habilitado, los eventos de conversión solo se dispararán después de un registro exitoso sin spam.',
                'sv' => 'Lägger till honeypot-skydd till WordPress och WooCommerce registreringsformulär. När aktiverat kommer konverteringshändelser endast att utlösas efter lyckad spam-fri registrering.',
                'pl' => 'Dodaje ochronę honeypot do formularzy rejestracji WordPress i WooCommerce. Po włączeniu zdarzenia konwersji będą wywoływane tylko po pomyślnej rejestracji bez spamu.',
                'et' => 'Lisab honeypot kaitse WordPressi ja WooCommerce registreerimisvormidele. Kui see on lubatud, käivitatakse konversioonisündmused ainult pärast edukat rämpsposti vaba registreerimist.'
            ],
            'protected_forms' => [
                'en' => 'Protected forms',
                'lt' => 'Saugomos formos',
                'it' => 'Moduli protetti',
                'de' => 'Geschützte Formulare',
                'es_MX' => 'Formularios protegidos',
                'es' => 'Formularios protegidos',
                'sv' => 'Skyddade formulär',
                'pl' => 'Chronione formularze',
                'et' => 'Kaitstud vormid'
            ],
            'registration_conversion_note' => [
                'en' => 'When enabled, registration conversion events (CompleteRegistration, sign_up, generate_lead) will only be fired to Facebook Pixel and Google Tag Manager after the registration passes spam checks.',
                'lt' => 'Įjungus, registracijos konversijos įvykiai (CompleteRegistration, sign_up, generate_lead) bus siunčiami į Facebook Pixel ir Google Tag Manager tik po to, kai registracija praeis šlamšto patikras.',
                'it' => 'Se abilitato, gli eventi di conversione della registrazione (CompleteRegistration, sign_up, generate_lead) verranno inviati a Facebook Pixel e Google Tag Manager solo dopo che la registrazione supera i controlli spam.',
                'de' => 'Bei Aktivierung werden Registrierungs-Conversion-Events (CompleteRegistration, sign_up, generate_lead) nur nach bestandener Spam-Prüfung an Facebook Pixel und Google Tag Manager gesendet.',
                'es_MX' => 'Cuando está habilitado, los eventos de conversión de registro (CompleteRegistration, sign_up, generate_lead) solo se enviarán a Facebook Pixel y Google Tag Manager después de que el registro pase las verificaciones de spam.',
                'es' => 'Cuando está habilitado, los eventos de conversión de registro (CompleteRegistration, sign_up, generate_lead) solo se enviarán a Facebook Pixel y Google Tag Manager después de que el registro pase las verificaciones de spam.',
                'sv' => 'När aktiverat kommer registreringskonverteringshändelser (CompleteRegistration, sign_up, generate_lead) endast att skickas till Facebook Pixel och Google Tag Manager efter att registreringen passerat spam-kontroller.',
                'pl' => 'Po włączeniu zdarzenia konwersji rejestracji (CompleteRegistration, sign_up, generate_lead) będą wysyłane do Facebook Pixel i Google Tag Manager tylko po tym, jak rejestracja przejdzie kontrole spamu.',
                'et' => 'Kui see on lubatud, saadetakse registreerimise konversioonisündmused (CompleteRegistration, sign_up, generate_lead) Facebook Pixelile ja Google Tag Managerile ainult pärast seda, kui registreerimine läbib rämpsposti kontrollid.'
            ],

            // Timestamp Settings
            'timestamp_protection' => [
                'en' => 'Timestamp Protection',
                'lt' => 'Laiko žymos apsauga',
                'it' => 'Protezione timestamp',
                'de' => 'Zeitstempel-Schutz',
                'es_MX' => 'Protección de marca de tiempo',
                'es' => 'Protección de marca de tiempo',
                'sv' => 'Tidsstämpelskydd',
                'pl' => 'Ochrona znacznikiem czasu',
                'et' => 'Ajatempli kaitse'
            ],
            'enable_timestamp' => [
                'en' => 'Enable Timestamp Check',
                'lt' => 'Įjungti laiko žymos tikrinimą',
                'it' => 'Abilita controllo timestamp',
                'de' => 'Zeitstempel-Prüfung aktivieren',
                'es_MX' => 'Habilitar verificación de marca de tiempo',
                'es' => 'Habilitar verificación de marca de tiempo',
                'sv' => 'Aktivera tidsstämpelkontroll',
                'pl' => 'Włącz sprawdzanie znacznika czasu',
                'et' => 'Luba ajatempli kontroll'
            ],
            'min_time_seconds' => [
                'en' => 'Minimum Time (seconds)',
                'lt' => 'Minimalus laikas (sekundėmis)',
                'it' => 'Tempo minimo (secondi)',
                'de' => 'Mindestzeit (Sekunden)',
                'es_MX' => 'Tiempo mínimo (segundos)',
                'es' => 'Tiempo mínimo (segundos)',
                'sv' => 'Minimitid (sekunder)',
                'pl' => 'Minimalny czas (sekundy)',
                'et' => 'Minimaalne aeg (sekundites)'
            ],
            'session_expiry' => [
                'en' => 'Session Expiry (seconds)',
                'lt' => 'Seanso galiojimo pabaiga (sekundėmis)',
                'it' => 'Scadenza sessione (secondi)',
                'de' => 'Sitzungsablauf (Sekunden)',
                'es_MX' => 'Expiración de sesión (segundos)',
                'es' => 'Expiración de sesión (segundos)',
                'sv' => 'Sessionsutgång (sekunder)',
                'pl' => 'Wygaśnięcie sesji (sekundy)',
                'et' => 'Seansi aegumine (sekundites)'
            ],

            // Rate Limiting
            'rate_limiting' => [
                'en' => 'Rate Limiting',
                'lt' => 'Užklausų ribojimas',
                'it' => 'Limitazione velocità',
                'de' => 'Ratenbegrenzung',
                'es_MX' => 'Limitación de velocidad',
                'es' => 'Limitación de velocidad',
                'sv' => 'Hastighetsbegränsning',
                'pl' => 'Ograniczanie szybkości',
                'et' => 'Kiiruse piiramine'
            ],
            'enable_rate_limiting' => [
                'en' => 'Enable Rate Limiting',
                'lt' => 'Įjungti užklausų ribojimą',
                'it' => 'Abilita limitazione velocità',
                'de' => 'Ratenbegrenzung aktivieren',
                'es_MX' => 'Habilitar limitación de velocidad',
                'es' => 'Habilitar limitación de velocidad',
                'sv' => 'Aktivera hastighetsbegränsning',
                'pl' => 'Włącz ograniczanie szybkości',
                'et' => 'Luba kiiruse piiramine'
            ],
            'max_submissions' => [
                'en' => 'Max Submissions',
                'lt' => 'Maks. pateikimų',
                'it' => 'Invii massimi',
                'de' => 'Max. Einreichungen',
                'es_MX' => 'Máximo de envíos',
                'es' => 'Máximo de envíos',
                'sv' => 'Max inskickningar',
                'pl' => 'Maks. zgłoszeń',
                'et' => 'Max esitusi'
            ],
            'time_window' => [
                'en' => 'Time Window (seconds)',
                'lt' => 'Laiko langas (sekundėmis)',
                'it' => 'Finestra temporale (secondi)',
                'de' => 'Zeitfenster (Sekunden)',
                'es_MX' => 'Ventana de tiempo (segundos)',
                'es' => 'Ventana de tiempo (segundos)',
                'sv' => 'Tidsfönster (sekunder)',
                'pl' => 'Okno czasowe (sekundy)',
                'et' => 'Ajaaken (sekundites)'
            ],

            // Character Filtering
            'character_filtering' => [
                'en' => 'Character Filtering',
                'lt' => 'Simbolių filtravimas',
                'it' => 'Filtraggio caratteri',
                'de' => 'Zeichenfilterung',
                'es_MX' => 'Filtrado de caracteres',
                'es' => 'Filtrado de caracteres',
                'sv' => 'Teckenfiltrering',
                'pl' => 'Filtrowanie znaków',
                'et' => 'Märkide filtreerimine'
            ],
            'block_cyrillic' => [
                'en' => 'Block Cyrillic Characters',
                'lt' => 'Blokuoti kirilicos simbolius',
                'it' => 'Blocca caratteri cirillici',
                'de' => 'Kyrillische Zeichen blockieren',
                'es_MX' => 'Bloquear caracteres cirílicos',
                'es' => 'Bloquear caracteres cirílicos',
                'sv' => 'Blockera kyrilliska tecken',
                'pl' => 'Blokuj znaki cyrylicy',
                'et' => 'Blokeeri kirillitsa märgid'
            ],
            'block_chinese' => [
                'en' => 'Block Chinese Characters',
                'lt' => 'Blokuoti kiniškus simbolius',
                'it' => 'Blocca caratteri cinesi',
                'de' => 'Chinesische Zeichen blockieren',
                'es_MX' => 'Bloquear caracteres chinos',
                'es' => 'Bloquear caracteres chinos',
                'sv' => 'Blockera kinesiska tecken',
                'pl' => 'Blokuj znaki chińskie',
                'et' => 'Blokeeri hiina märgid'
            ],
            'block_south_asian' => [
                'en' => 'Block South Asian Scripts',
                'lt' => 'Blokuoti Pietų Azijos raštus',
                'it' => 'Blocca scritture sud asiatiche',
                'de' => 'Südasiatische Schriften blockieren',
                'es_MX' => 'Bloquear escrituras del sur de Asia',
                'es' => 'Bloquear escrituras del sur de Asia',
                'sv' => 'Blockera sydasiatiska skriftspråk',
                'pl' => 'Blokuj pisma południowoazjatyckie',
                'et' => 'Blokeeri Lõuna-Aasia kirjad'
            ],
            'block_south_asian_desc' => [
                'en' => 'Bengali, Hindi, Tamil, Telugu, and other South Asian scripts',
                'lt' => 'Bengalų, hindi, tamilų, telugų ir kiti Pietų Azijos raštai',
                'it' => 'Bengali, Hindi, Tamil, Telugu e altre scritture sud asiatiche',
                'de' => 'Bengali, Hindi, Tamil, Telugu und andere südasiatische Schriften',
                'es_MX' => 'Bengalí, hindi, tamil, telugu y otras escrituras del sur de Asia',
                'es' => 'Bengalí, hindi, tamil, telugu y otras escrituras del sur de Asia',
                'sv' => 'Bengali, hindi, tamil, telugu och andra sydasiatiska skriftspråk',
                'pl' => 'Bengalski, hindi, tamilski, telugu i inne pisma południowoazjatyckie',
                'et' => 'Bengali, hindi, tamili, telugu ja muud Lõuna-Aasia kirjad'
            ],
            'block_latin' => [
                'en' => 'Block Latin Characters',
                'lt' => 'Blokuoti lotyniškus simbolius',
                'it' => 'Blocca caratteri latini',
                'de' => 'Lateinische Zeichen blockieren',
                'es_MX' => 'Bloquear caracteres latinos',
                'es' => 'Bloquear caracteres latinos',
                'sv' => 'Blockera latinska tecken',
                'pl' => 'Blokuj znaki łacińskie',
                'et' => 'Blokeeri ladina märgid'
            ],
            'block_latin_warning' => [
                'en' => 'Warning: This will block English and most European languages!',
                'lt' => 'Įspėjimas: Tai užblokuos anglų ir daugumą Europos kalbų!',
                'it' => 'Attenzione: Questo bloccherà l\'inglese e la maggior parte delle lingue europee!',
                'de' => 'Warnung: Dies blockiert Englisch und die meisten europäischen Sprachen!',
                'es_MX' => '¡Advertencia: Esto bloqueará el inglés y la mayoría de los idiomas europeos!',
                'es' => '¡Advertencia: Esto bloqueará el inglés y la mayoría de los idiomas europeos!',
                'sv' => 'Varning: Detta blockerar engelska och de flesta europeiska språk!',
                'pl' => 'Ostrzeżenie: To zablokuje angielski i większość języków europejskich!',
                'et' => 'Hoiatus: See blokeerib inglise ja enamiku Euroopa keeli!'
            ],

            // Blacklists
            'email_blacklist' => [
                'en' => 'Email Blacklist',
                'lt' => 'El. pašto juodasis sąrašas',
                'it' => 'Lista nera email',
                'de' => 'E-Mail-Sperrliste',
                'es_MX' => 'Lista negra de emails',
                'es' => 'Lista negra de emails',
                'sv' => 'E-postsvartlista',
                'pl' => 'Czarna lista email',
                'et' => 'E-posti must nimekiri'
            ],
            'blocked_emails' => [
                'en' => 'Blocked Emails (one per line)',
                'lt' => 'Užblokuoti el. paštai (po vieną eilutėje)',
                'it' => 'Email bloccate (una per riga)',
                'de' => 'Gesperrte E-Mails (eine pro Zeile)',
                'es_MX' => 'Emails bloqueados (uno por línea)',
                'es' => 'Emails bloqueados (uno por línea)',
                'sv' => 'Blockerade e-postadresser (en per rad)',
                'pl' => 'Zablokowane emaile (jeden na linię)',
                'et' => 'Blokeeritud e-postid (üks rea kohta)'
            ],
            'supports_wildcards' => [
                'en' => 'Supports wildcards: *@spammer.com',
                'lt' => 'Palaiko šablonus: *@spammer.com',
                'it' => 'Supporta caratteri jolly: *@spammer.com',
                'de' => 'Unterstützt Platzhalter: *@spammer.com',
                'es_MX' => 'Soporta comodines: *@spammer.com',
                'es' => 'Soporta comodines: *@spammer.com',
                'sv' => 'Stöder jokertecken: *@spammer.com',
                'pl' => 'Obsługuje znaki wieloznaczne: *@spammer.com',
                'et' => 'Toetab metamärke: *@spammer.com'
            ],
            'domain_blacklist' => [
                'en' => 'Domain Blacklist',
                'lt' => 'Domenų juodasis sąrašas',
                'it' => 'Lista nera domini',
                'de' => 'Domain-Sperrliste',
                'es_MX' => 'Lista negra de dominios',
                'es' => 'Lista negra de dominios',
                'sv' => 'Domänsvartlista',
                'pl' => 'Czarna lista domen',
                'et' => 'Domeenide must nimekiri'
            ],
            'blocked_domains' => [
                'en' => 'Blocked Domains (one per line)',
                'lt' => 'Užblokuoti domenai (po vieną eilutėje)',
                'it' => 'Domini bloccati (uno per riga)',
                'de' => 'Gesperrte Domains (eine pro Zeile)',
                'es_MX' => 'Dominios bloqueados (uno por línea)',
                'es' => 'Dominios bloqueados (uno por línea)',
                'sv' => 'Blockerade domäner (en per rad)',
                'pl' => 'Zablokowane domeny (jedna na linię)',
                'et' => 'Blokeeritud domeenid (üks rea kohta)'
            ],
            'use_wildcard_subdomain' => [
                'en' => 'Use *.domain.com for subdomains',
                'lt' => 'Naudokite *.domain.com subdomenams',
                'it' => 'Usa *.domain.com per i sottodomini',
                'de' => 'Verwenden Sie *.domain.com für Subdomains',
                'es_MX' => 'Usa *.domain.com para subdominios',
                'es' => 'Usa *.domain.com para subdominios',
                'sv' => 'Använd *.domain.com för subdomäner',
                'pl' => 'Użyj *.domain.com dla subdomen',
                'et' => 'Kasutage *.domain.com alamdomeenide jaoks'
            ],
            'ip_blacklist' => [
                'en' => 'IP Blacklist',
                'lt' => 'IP juodasis sąrašas',
                'it' => 'Lista nera IP',
                'de' => 'IP-Sperrliste',
                'es_MX' => 'Lista negra de IP',
                'es' => 'Lista negra de IP',
                'sv' => 'IP-svartlista',
                'pl' => 'Czarna lista IP',
                'et' => 'IP must nimekiri'
            ],
            'blocked_ips' => [
                'en' => 'Blocked IPs (one per line)',
                'lt' => 'Užblokuoti IP (po vieną eilutėje)',
                'it' => 'IP bloccati (uno per riga)',
                'de' => 'Gesperrte IPs (eine pro Zeile)',
                'es_MX' => 'IPs bloqueadas (una por línea)',
                'es' => 'IPs bloqueadas (una por línea)',
                'sv' => 'Blockerade IP-adresser (en per rad)',
                'pl' => 'Zablokowane IP (jeden na linię)',
                'et' => 'Blokeeritud IP-d (üks rea kohta)'
            ],
            'supports_cidr' => [
                'en' => 'Supports CIDR: 192.168.1.0/24',
                'lt' => 'Palaiko CIDR: 192.168.1.0/24',
                'it' => 'Supporta CIDR: 192.168.1.0/24',
                'de' => 'Unterstützt CIDR: 192.168.1.0/24',
                'es_MX' => 'Soporta CIDR: 192.168.1.0/24',
                'es' => 'Soporta CIDR: 192.168.1.0/24',
                'sv' => 'Stöder CIDR: 192.168.1.0/24',
                'pl' => 'Obsługuje CIDR: 192.168.1.0/24',
                'et' => 'Toetab CIDR-i: 192.168.1.0/24'
            ],

            // Keywords
            'keyword_blacklist_subject' => [
                'en' => 'Subject Keywords',
                'lt' => 'Temos raktažodžiai',
                'it' => 'Parole chiave oggetto',
                'de' => 'Betreff-Schlüsselwörter',
                'es_MX' => 'Palabras clave de asunto',
                'es' => 'Palabras clave de asunto',
                'sv' => 'Ämnesnyckelord',
                'pl' => 'Słowa kluczowe tematu',
                'et' => 'Teema võtmesõnad'
            ],
            'keyword_blacklist_body' => [
                'en' => 'Body Keywords',
                'lt' => 'Turinio raktažodžiai',
                'it' => 'Parole chiave corpo',
                'de' => 'Text-Schlüsselwörter',
                'es_MX' => 'Palabras clave del cuerpo',
                'es' => 'Palabras clave del cuerpo',
                'sv' => 'Brödtextsnyckelord',
                'pl' => 'Słowa kluczowe treści',
                'et' => 'Sisu võtmesõnad'
            ],
            'keyword_blacklist_all' => [
                'en' => 'Global Keywords',
                'lt' => 'Globalūs raktažodžiai',
                'it' => 'Parole chiave globali',
                'de' => 'Globale Schlüsselwörter',
                'es_MX' => 'Palabras clave globales',
                'es' => 'Palabras clave globales',
                'sv' => 'Globala nyckelord',
                'pl' => 'Globalne słowa kluczowe',
                'et' => 'Globaalsed võtmesõnad'
            ],
            'blocked_keywords' => [
                'en' => 'Blocked Keywords (one per line)',
                'lt' => 'Užblokuoti raktažodžiai (po vieną eilutėje)',
                'it' => 'Parole chiave bloccate (una per riga)',
                'de' => 'Gesperrte Schlüsselwörter (eines pro Zeile)',
                'es_MX' => 'Palabras clave bloqueadas (una por línea)',
                'es' => 'Palabras clave bloqueadas (una por línea)',
                'sv' => 'Blockerade nyckelord (ett per rad)',
                'pl' => 'Zablokowane słowa kluczowe (jedno na linię)',
                'et' => 'Blokeeritud võtmesõnad (üks rea kohta)'
            ],

            // Heuristics
            'heuristic_analysis' => [
                'en' => 'Heuristic Analysis',
                'lt' => 'Euristinė analizė',
                'it' => 'Analisi euristica',
                'de' => 'Heuristische Analyse',
                'es_MX' => 'Análisis heurístico',
                'es' => 'Análisis heurístico',
                'sv' => 'Heuristisk analys',
                'pl' => 'Analiza heurystyczna',
                'et' => 'Heuristiline analüüs'
            ],
            'enable_heuristics' => [
                'en' => 'Enable Heuristic Analysis',
                'lt' => 'Įjungti euristinę analizę',
                'it' => 'Abilita analisi euristica',
                'de' => 'Heuristische Analyse aktivieren',
                'es_MX' => 'Habilitar análisis heurístico',
                'es' => 'Habilitar análisis heurístico',
                'sv' => 'Aktivera heuristisk analys',
                'pl' => 'Włącz analizę heurystyczną',
                'et' => 'Luba heuristiline analüüs'
            ],
            'max_links' => [
                'en' => 'Maximum Links Allowed',
                'lt' => 'Maksimalus leidžiamų nuorodų skaičius',
                'it' => 'Link massimi consentiti',
                'de' => 'Maximal erlaubte Links',
                'es_MX' => 'Máximo de enlaces permitidos',
                'es' => 'Máximo de enlaces permitidos',
                'sv' => 'Maximalt tillåtna länkar',
                'pl' => 'Maksymalna liczba linków',
                'et' => 'Maksimaalselt lubatud linke'
            ],
            'spam_threshold' => [
                'en' => 'Spam Score Threshold',
                'lt' => 'Šlamšto balo riba',
                'it' => 'Soglia punteggio spam',
                'de' => 'Spam-Score-Schwellenwert',
                'es_MX' => 'Umbral de puntuación de spam',
                'es' => 'Umbral de puntuación de spam',
                'sv' => 'Tröskel för skräppostpoäng',
                'pl' => 'Próg wyniku spamu',
                'et' => 'Rämpsposti skoori lävi'
            ],

            // Logging
            'logging_settings' => [
                'en' => 'Logging Settings',
                'lt' => 'Žurnalo nustatymai',
                'it' => 'Impostazioni registro',
                'de' => 'Protokolleinstellungen',
                'es_MX' => 'Configuración de registros',
                'es' => 'Configuración de registros',
                'sv' => 'Logginställningar',
                'pl' => 'Ustawienia logowania',
                'et' => 'Logimise seaded'
            ],
            'log_retention' => [
                'en' => 'Log Retention (days)',
                'lt' => 'Žurnalo saugojimo laikotarpis (dienomis)',
                'it' => 'Conservazione log (giorni)',
                'de' => 'Protokollaufbewahrung (Tage)',
                'es_MX' => 'Retención de registros (días)',
                'es' => 'Retención de registros (días)',
                'sv' => 'Logglagring (dagar)',
                'pl' => 'Przechowywanie logów (dni)',
                'et' => 'Logide säilitamine (päevades)'
            ],
            'log_clean_submissions' => [
                'en' => 'Log Clean Submissions',
                'lt' => 'Registruoti švarių pateikimus',
                'it' => 'Registra invii puliti',
                'de' => 'Saubere Einreichungen protokollieren',
                'es_MX' => 'Registrar envíos limpios',
                'es' => 'Registrar envíos limpios',
                'sv' => 'Logga rena inskickningar',
                'pl' => 'Loguj czyste zgłoszenia',
                'et' => 'Logi puhtad esitused'
            ],

            // Advanced
            'advanced_settings' => [
                'en' => 'Advanced Settings',
                'lt' => 'Išplėstiniai nustatymai',
                'it' => 'Impostazioni avanzate',
                'de' => 'Erweiterte Einstellungen',
                'es_MX' => 'Configuración avanzada',
                'es' => 'Configuración avanzada',
                'sv' => 'Avancerade inställningar',
                'pl' => 'Ustawienia zaawansowane',
                'et' => 'Täpsemad seaded'
            ],
            'whitelist_logged_in' => [
                'en' => 'Whitelist Logged-in Users',
                'lt' => 'Leisti prisijungusius naudotojus',
                'it' => 'Whitelist utenti connessi',
                'de' => 'Angemeldete Benutzer auf Whitelist',
                'es_MX' => 'Permitir usuarios conectados',
                'es' => 'Permitir usuarios conectados',
                'sv' => 'Vitlista inloggade användare',
                'pl' => 'Białą listą zalogowanych użytkowników',
                'et' => 'Luba sisselogitud kasutajad'
            ],
            'delete_on_uninstall' => [
                'en' => 'Delete Data on Uninstall',
                'lt' => 'Ištrinti duomenis pašalinant',
                'it' => 'Elimina dati alla disinstallazione',
                'de' => 'Daten bei Deinstallation löschen',
                'es_MX' => 'Eliminar datos al desinstalar',
                'es' => 'Eliminar datos al desinstalar',
                'sv' => 'Radera data vid avinstallation',
                'pl' => 'Usuń dane przy odinstalowaniu',
                'et' => 'Kustuta andmed desinstallimisel'
            ],

            // =====================================================
            // LOGS PAGE
            // =====================================================
            'logs_subtitle' => [
                'en' => 'Review all form submissions and their spam status',
                'lt' => 'Peržiūrėkite visus formų pateikimus ir jų šlamšto būseną',
                'it' => 'Rivedi tutti gli invii dei moduli e il loro stato spam',
                'de' => 'Überprüfen Sie alle Formulareinreichungen und deren Spam-Status',
                'es_MX' => 'Revisa todos los envíos de formularios y su estado de spam',
                'es' => 'Revisa todos los envíos de formularios y su estado de spam',
                'sv' => 'Granska alla formulärinskickningar och deras skräppoststatus',
                'pl' => 'Przejrzyj wszystkie zgłoszenia formularzy i ich status spamu',
                'et' => 'Vaadake üle kõik vormide esitused ja nende rämpsposti olek'
            ],
            'filters' => [
                'en' => 'Filters',
                'lt' => 'Filtrai',
                'it' => 'Filtri',
                'de' => 'Filter',
                'es_MX' => 'Filtros',
                'es' => 'Filtros',
                'sv' => 'Filter',
                'pl' => 'Filtry',
                'et' => 'Filtrid'
            ],
            'show_filters' => [
                'en' => 'Show Filters',
                'lt' => 'Rodyti filtrus',
                'it' => 'Mostra filtri',
                'de' => 'Filter anzeigen',
                'es_MX' => 'Mostrar filtros',
                'es' => 'Mostrar filtros',
                'sv' => 'Visa filter',
                'pl' => 'Pokaż filtry',
                'et' => 'Näita filtreid'
            ],
            'hide_filters' => [
                'en' => 'Hide Filters',
                'lt' => 'Slėpti filtrus',
                'it' => 'Nascondi filtri',
                'de' => 'Filter ausblenden',
                'es_MX' => 'Ocultar filtros',
                'es' => 'Ocultar filtros',
                'sv' => 'Dölj filter',
                'pl' => 'Ukryj filtry',
                'et' => 'Peida filtrid'
            ],
            'status' => [
                'en' => 'Status',
                'lt' => 'Būsena',
                'it' => 'Stato',
                'de' => 'Status',
                'es_MX' => 'Estado',
                'es' => 'Estado',
                'sv' => 'Status',
                'pl' => 'Status',
                'et' => 'Olek'
            ],
            'all' => [
                'en' => 'All',
                'lt' => 'Visi',
                'it' => 'Tutti',
                'de' => 'Alle',
                'es_MX' => 'Todos',
                'es' => 'Todos',
                'sv' => 'Alla',
                'pl' => 'Wszystkie',
                'et' => 'Kõik'
            ],
            'spam_only' => [
                'en' => 'Spam Only',
                'lt' => 'Tik šlamštas',
                'it' => 'Solo spam',
                'de' => 'Nur Spam',
                'es_MX' => 'Solo spam',
                'es' => 'Solo spam',
                'sv' => 'Endast skräppost',
                'pl' => 'Tylko spam',
                'et' => 'Ainult rämpspost'
            ],
            'clean_only' => [
                'en' => 'Clean Only',
                'lt' => 'Tik švarūs',
                'it' => 'Solo puliti',
                'de' => 'Nur sauber',
                'es_MX' => 'Solo limpios',
                'es' => 'Solo limpios',
                'sv' => 'Endast rena',
                'pl' => 'Tylko czyste',
                'et' => 'Ainult puhtad'
            ],
            'spam_type' => [
                'en' => 'Spam Type',
                'lt' => 'Šlamšto tipas',
                'it' => 'Tipo di spam',
                'de' => 'Spam-Typ',
                'es_MX' => 'Tipo de spam',
                'es' => 'Tipo de spam',
                'sv' => 'Skräpposttyp',
                'pl' => 'Typ spamu',
                'et' => 'Rämpsposti tüüp'
            ],
            'all_types' => [
                'en' => 'All Types',
                'lt' => 'Visi tipai',
                'it' => 'Tutti i tipi',
                'de' => 'Alle Typen',
                'es_MX' => 'Todos los tipos',
                'es' => 'Todos los tipos',
                'sv' => 'Alla typer',
                'pl' => 'Wszystkie typy',
                'et' => 'Kõik tüübid'
            ],
            'honeypot_triggered' => [
                'en' => 'Honeypot Triggered',
                'lt' => 'Suaktyvintas Honeypot',
                'it' => 'Honeypot attivato',
                'de' => 'Honeypot ausgelöst',
                'es_MX' => 'Honeypot activado',
                'es' => 'Honeypot activado',
                'sv' => 'Honeypot utlöst',
                'pl' => 'Honeypot aktywowany',
                'et' => 'Honeypot aktiveeritud'
            ],
            'timestamp_too_fast' => [
                'en' => 'Timestamp (Too Fast/Slow)',
                'lt' => 'Laiko žyma (per greitas/lėtas)',
                'it' => 'Timestamp (troppo veloce/lento)',
                'de' => 'Zeitstempel (zu schnell/langsam)',
                'es_MX' => 'Marca de tiempo (muy rápido/lento)',
                'es' => 'Marca de tiempo (muy rápido/lento)',
                'sv' => 'Tidsstämpel (för snabb/långsam)',
                'pl' => 'Znacznik czasu (za szybko/wolno)',
                'et' => 'Ajatempel (liiga kiire/aeglane)'
            ],
            'blacklisted' => [
                'en' => 'Blacklisted',
                'lt' => 'Juodajame sąraše',
                'it' => 'In lista nera',
                'de' => 'Gesperrt',
                'es_MX' => 'En lista negra',
                'es' => 'En lista negra',
                'sv' => 'Svartlistad',
                'pl' => 'Na czarnej liście',
                'et' => 'Mustas nimekirjas'
            ],
            'cyrillic_chars' => [
                'en' => 'Cyrillic Characters',
                'lt' => 'Kirilicos simboliai',
                'it' => 'Caratteri cirillici',
                'de' => 'Kyrillische Zeichen',
                'es_MX' => 'Caracteres cirílicos',
                'es' => 'Caracteres cirílicos',
                'sv' => 'Kyrilliska tecken',
                'pl' => 'Znaki cyrylicy',
                'et' => 'Kirillitsa märgid'
            ],
            'chinese_chars' => [
                'en' => 'Chinese Characters',
                'lt' => 'Kiniški simboliai',
                'it' => 'Caratteri cinesi',
                'de' => 'Chinesische Zeichen',
                'es_MX' => 'Caracteres chinos',
                'es' => 'Caracteres chinos',
                'sv' => 'Kinesiska tecken',
                'pl' => 'Znaki chińskie',
                'et' => 'Hiina märgid'
            ],
            'gibberish_detected' => [
                'en' => 'Gibberish Detected',
                'lt' => 'Aptikta nesąmonė',
                'it' => 'Rilevato testo senza senso',
                'de' => 'Unsinn erkannt',
                'es_MX' => 'Texto sin sentido detectado',
                'es' => 'Texto sin sentido detectado',
                'sv' => 'Nonsens upptäckt',
                'pl' => 'Wykryto bełkot',
                'et' => 'Tuvastati mõttetu tekst'
            ],
            'too_many_links' => [
                'en' => 'Too Many Links',
                'lt' => 'Per daug nuorodų',
                'it' => 'Troppi link',
                'de' => 'Zu viele Links',
                'es_MX' => 'Demasiados enlaces',
                'es' => 'Demasiados enlaces',
                'sv' => 'För många länkar',
                'pl' => 'Za dużo linków',
                'et' => 'Liiga palju linke'
            ],
            'rate_limited' => [
                'en' => 'Rate Limited',
                'lt' => 'Ribojama',
                'it' => 'Limite raggiunto',
                'de' => 'Rate begrenzt',
                'es_MX' => 'Límite alcanzado',
                'es' => 'Límite alcanzado',
                'sv' => 'Hastighetsbegränsad',
                'pl' => 'Ograniczono',
                'et' => 'Piiratud'
            ],
            'heuristic_score' => [
                'en' => 'Heuristic Score',
                'lt' => 'Euristinis balas',
                'it' => 'Punteggio euristico',
                'de' => 'Heuristischer Score',
                'es_MX' => 'Puntuación heurística',
                'es' => 'Puntuación heurística',
                'sv' => 'Heuristisk poäng',
                'pl' => 'Wynik heurystyczny',
                'et' => 'Heuristiline skoor'
            ],
            'character_filter' => [
                'en' => 'Character Filter',
                'lt' => 'Simbolių filtras',
                'it' => 'Filtro caratteri',
                'de' => 'Zeichenfilter',
                'es_MX' => 'Filtro de caracteres',
                'es' => 'Filtro de caracteres',
                'sv' => 'Teckenfilter',
                'pl' => 'Filtr znaków',
                'et' => 'Märgifilter'
            ],
            'no_filter' => [
                'en' => 'No Filter',
                'lt' => 'Be filtro',
                'it' => 'Nessun filtro',
                'de' => 'Kein Filter',
                'es_MX' => 'Sin filtro',
                'es' => 'Sin filtro',
                'sv' => 'Inget filter',
                'pl' => 'Bez filtra',
                'et' => 'Filtrita'
            ],
            'has_cyrillic' => [
                'en' => 'Has Cyrillic (Russian)',
                'lt' => 'Turi kirilicą (rusų)',
                'it' => 'Ha caratteri cirillici (russo)',
                'de' => 'Hat Kyrillisch (Russisch)',
                'es_MX' => 'Tiene cirílico (ruso)',
                'es' => 'Tiene cirílico (ruso)',
                'sv' => 'Har kyrilliska (ryska)',
                'pl' => 'Ma cyrylicę (rosyjski)',
                'et' => 'On kirillitsa (vene)'
            ],
            'has_chinese' => [
                'en' => 'Has Chinese Characters',
                'lt' => 'Turi kiniškų simbolių',
                'it' => 'Ha caratteri cinesi',
                'de' => 'Hat chinesische Zeichen',
                'es_MX' => 'Tiene caracteres chinos',
                'es' => 'Tiene caracteres chinos',
                'sv' => 'Har kinesiska tecken',
                'pl' => 'Ma znaki chińskie',
                'et' => 'On hiina märke'
            ],
            'has_foreign' => [
                'en' => 'Has Cyrillic OR Chinese',
                'lt' => 'Turi kirilicą ARBA kinišką',
                'it' => 'Ha cirillico O cinese',
                'de' => 'Hat Kyrillisch ODER Chinesisch',
                'es_MX' => 'Tiene cirílico O chino',
                'es' => 'Tiene cirílico O chino',
                'sv' => 'Har kyrilliska ELLER kinesiska',
                'pl' => 'Ma cyrylicę LUB chińskie',
                'et' => 'On kirillitsa VÕI hiina'
            ],
            'exclude_cyrillic' => [
                'en' => 'Exclude Cyrillic',
                'lt' => 'Išskirti kirilicą',
                'it' => 'Escludi cirillico',
                'de' => 'Kyrillisch ausschließen',
                'es_MX' => 'Excluir cirílico',
                'es' => 'Excluir cirílico',
                'sv' => 'Exkludera kyrilliska',
                'pl' => 'Wyklucz cyrylicę',
                'et' => 'Välista kirillitsa'
            ],
            'exclude_chinese' => [
                'en' => 'Exclude Chinese',
                'lt' => 'Išskirti kinišką',
                'it' => 'Escludi cinese',
                'de' => 'Chinesisch ausschließen',
                'es_MX' => 'Excluir chino',
                'es' => 'Excluir chino',
                'sv' => 'Exkludera kinesiska',
                'pl' => 'Wyklucz chińskie',
                'et' => 'Välista hiina'
            ],
            'exclude_foreign' => [
                'en' => 'Exclude Cyrillic AND Chinese',
                'lt' => 'Išskirti kirilicą IR kinišką',
                'it' => 'Escludi cirillico E cinese',
                'de' => 'Kyrillisch UND Chinesisch ausschließen',
                'es_MX' => 'Excluir cirílico Y chino',
                'es' => 'Excluir cirílico Y chino',
                'sv' => 'Exkludera kyrilliska OCH kinesiska',
                'pl' => 'Wyklucz cyrylicę I chińskie',
                'et' => 'Välista kirillitsa JA hiina'
            ],
            'form_source' => [
                'en' => 'Form Source',
                'lt' => 'Formos šaltinis',
                'it' => 'Origine modulo',
                'de' => 'Formularquelle',
                'es_MX' => 'Origen del formulario',
                'es' => 'Origen del formulario',
                'sv' => 'Formulärkälla',
                'pl' => 'Źródło formularza',
                'et' => 'Vormi allikas'
            ],
            'all_sources' => [
                'en' => 'All Sources',
                'lt' => 'Visi šaltiniai',
                'it' => 'Tutte le origini',
                'de' => 'Alle Quellen',
                'es_MX' => 'Todos los orígenes',
                'es' => 'Todos los orígenes',
                'sv' => 'Alla källor',
                'pl' => 'Wszystkie źródła',
                'et' => 'Kõik allikad'
            ],
            'date_range' => [
                'en' => 'Date Range',
                'lt' => 'Datų intervalas',
                'it' => 'Intervallo date',
                'de' => 'Datumsbereich',
                'es_MX' => 'Rango de fechas',
                'es' => 'Rango de fechas',
                'sv' => 'Datumintervall',
                'pl' => 'Zakres dat',
                'et' => 'Kuupäevavahemik'
            ],
            'all_time' => [
                'en' => 'All Time',
                'lt' => 'Visą laiką',
                'it' => 'Sempre',
                'de' => 'Gesamte Zeit',
                'es_MX' => 'Todo el tiempo',
                'es' => 'Todo el tiempo',
                'sv' => 'Alla tider',
                'pl' => 'Cały czas',
                'et' => 'Kogu aeg'
            ],
            'today' => [
                'en' => 'Today',
                'lt' => 'Šiandien',
                'it' => 'Oggi',
                'de' => 'Heute',
                'es_MX' => 'Hoy',
                'es' => 'Hoy',
                'sv' => 'Idag',
                'pl' => 'Dzisiaj',
                'et' => 'Täna'
            ],
            'yesterday' => [
                'en' => 'Yesterday',
                'lt' => 'Vakar',
                'it' => 'Ieri',
                'de' => 'Gestern',
                'es_MX' => 'Ayer',
                'es' => 'Ayer',
                'sv' => 'Igår',
                'pl' => 'Wczoraj',
                'et' => 'Eile'
            ],
            'last_7_days' => [
                'en' => 'Last 7 Days',
                'lt' => 'Paskutinės 7 dienos',
                'it' => 'Ultimi 7 giorni',
                'de' => 'Letzte 7 Tage',
                'es_MX' => 'Últimos 7 días',
                'es' => 'Últimos 7 días',
                'sv' => 'Senaste 7 dagarna',
                'pl' => 'Ostatnie 7 dni',
                'et' => 'Viimased 7 päeva'
            ],
            'last_30_days' => [
                'en' => 'Last 30 Days',
                'lt' => 'Paskutinės 30 dienų',
                'it' => 'Ultimi 30 giorni',
                'de' => 'Letzte 30 Tage',
                'es_MX' => 'Últimos 30 días',
                'es' => 'Últimos 30 días',
                'sv' => 'Senaste 30 dagarna',
                'pl' => 'Ostatnie 30 dni',
                'et' => 'Viimased 30 päeva'
            ],
            'this_month' => [
                'en' => 'This Month',
                'lt' => 'Šį mėnesį',
                'it' => 'Questo mese',
                'de' => 'Dieser Monat',
                'es_MX' => 'Este mes',
                'es' => 'Este mes',
                'sv' => 'Denna månad',
                'pl' => 'Ten miesiąc',
                'et' => 'See kuu'
            ],
            'last_month' => [
                'en' => 'Last Month',
                'lt' => 'Praėjusį mėnesį',
                'it' => 'Mese scorso',
                'de' => 'Letzter Monat',
                'es_MX' => 'Mes pasado',
                'es' => 'Mes pasado',
                'sv' => 'Förra månaden',
                'pl' => 'Poprzedni miesiąc',
                'et' => 'Eelmine kuu'
            ],
            'custom_range' => [
                'en' => 'Custom Range',
                'lt' => 'Pasirinktinis intervalas',
                'it' => 'Intervallo personalizzato',
                'de' => 'Benutzerdefinierter Bereich',
                'es_MX' => 'Rango personalizado',
                'es' => 'Rango personalizado',
                'sv' => 'Anpassat intervall',
                'pl' => 'Niestandardowy zakres',
                'et' => 'Kohandatud vahemik'
            ],
            'from_date' => [
                'en' => 'From Date',
                'lt' => 'Nuo datos',
                'it' => 'Dalla data',
                'de' => 'Von Datum',
                'es_MX' => 'Desde fecha',
                'es' => 'Desde fecha',
                'sv' => 'Från datum',
                'pl' => 'Od daty',
                'et' => 'Alates kuupäevast'
            ],
            'to_date' => [
                'en' => 'To Date',
                'lt' => 'Iki datos',
                'it' => 'Alla data',
                'de' => 'Bis Datum',
                'es_MX' => 'Hasta fecha',
                'es' => 'Hasta fecha',
                'sv' => 'Till datum',
                'pl' => 'Do daty',
                'et' => 'Kuni kuupäevani'
            ],
            'specific_date' => [
                'en' => 'Specific Date',
                'lt' => 'Konkreti data',
                'it' => 'Data specifica',
                'de' => 'Bestimmtes Datum',
                'es_MX' => 'Fecha específica',
                'es' => 'Fecha específica',
                'sv' => 'Specifikt datum',
                'pl' => 'Konkretna data',
                'et' => 'Konkreetne kuupäev'
            ],
            'search_content' => [
                'en' => 'Search Content',
                'lt' => 'Ieškoti turinyje',
                'it' => 'Cerca contenuto',
                'de' => 'Inhalt durchsuchen',
                'es_MX' => 'Buscar contenido',
                'es' => 'Buscar contenido',
                'sv' => 'Sök innehåll',
                'pl' => 'Szukaj w treści',
                'et' => 'Otsi sisust'
            ],
            'search_placeholder' => [
                'en' => 'Search in content, IP, reason...',
                'lt' => 'Ieškoti turinyje, IP, priežastyje...',
                'it' => 'Cerca in contenuto, IP, motivo...',
                'de' => 'Suche in Inhalt, IP, Grund...',
                'es_MX' => 'Buscar en contenido, IP, razón...',
                'es' => 'Buscar en contenido, IP, razón...',
                'sv' => 'Sök i innehåll, IP, anledning...',
                'pl' => 'Szukaj w treści, IP, powodzie...',
                'et' => 'Otsi sisust, IP-st, põhjusest...'
            ],
            'apply_filters' => [
                'en' => 'Apply Filters',
                'lt' => 'Taikyti filtrus',
                'it' => 'Applica filtri',
                'de' => 'Filter anwenden',
                'es_MX' => 'Aplicar filtros',
                'es' => 'Aplicar filtros',
                'sv' => 'Tillämpa filter',
                'pl' => 'Zastosuj filtry',
                'et' => 'Rakenda filtrid'
            ],
            'clear' => [
                'en' => 'Clear',
                'lt' => 'Išvalyti',
                'it' => 'Cancella',
                'de' => 'Löschen',
                'es_MX' => 'Limpiar',
                'es' => 'Limpiar',
                'sv' => 'Rensa',
                'pl' => 'Wyczyść',
                'et' => 'Tühjenda'
            ],
            'results' => [
                'en' => 'results',
                'lt' => 'rezultatai',
                'it' => 'risultati',
                'de' => 'Ergebnisse',
                'es_MX' => 'resultados',
                'es' => 'resultados',
                'sv' => 'resultat',
                'pl' => 'wyników',
                'et' => 'tulemust'
            ],
            'total_entries' => [
                'en' => 'total entries',
                'lt' => 'viso įrašų',
                'it' => 'voci totali',
                'de' => 'Einträge gesamt',
                'es_MX' => 'entradas totales',
                'es' => 'entradas totales',
                'sv' => 'totalt antal poster',
                'pl' => 'wszystkich wpisów',
                'et' => 'kirjet kokku'
            ],
            'clear_all_logs' => [
                'en' => 'Clear All Logs',
                'lt' => 'Išvalyti visus žurnalus',
                'it' => 'Cancella tutti i registri',
                'de' => 'Alle Protokolle löschen',
                'es_MX' => 'Borrar todos los registros',
                'es' => 'Borrar todos los registros',
                'sv' => 'Rensa alla loggar',
                'pl' => 'Wyczyść wszystkie logi',
                'et' => 'Tühjenda kõik logid'
            ],
            'export_csv' => [
                'en' => 'Export CSV',
                'lt' => 'Eksportuoti CSV',
                'it' => 'Esporta CSV',
                'de' => 'CSV exportieren',
                'es_MX' => 'Exportar CSV',
                'es' => 'Exportar CSV',
                'sv' => 'Exportera CSV',
                'pl' => 'Eksportuj CSV',
                'et' => 'Ekspordi CSV'
            ],
            'no_logs_found' => [
                'en' => 'No log entries found.',
                'lt' => 'Žurnalo įrašų nerasta.',
                'it' => 'Nessuna voce di registro trovata.',
                'de' => 'Keine Protokolleinträge gefunden.',
                'es_MX' => 'No se encontraron entradas de registro.',
                'es' => 'No se encontraron entradas de registro.',
                'sv' => 'Inga loggposter hittades.',
                'pl' => 'Nie znaleziono wpisów w logu.',
                'et' => 'Logikirjeid ei leitud.'
            ],
            'score' => [
                'en' => 'Score',
                'lt' => 'Balas',
                'it' => 'Punteggio',
                'de' => 'Punktzahl',
                'es_MX' => 'Puntuación',
                'es' => 'Puntuación',
                'sv' => 'Poäng',
                'pl' => 'Wynik',
                'et' => 'Skoor'
            ],
            'reason' => [
                'en' => 'Reason',
                'lt' => 'Priežastis',
                'it' => 'Motivo',
                'de' => 'Grund',
                'es_MX' => 'Razón',
                'es' => 'Razón',
                'sv' => 'Anledning',
                'pl' => 'Powód',
                'et' => 'Põhjus'
            ],
            'content_preview' => [
                'en' => 'Content Preview',
                'lt' => 'Turinio peržiūra',
                'it' => 'Anteprima contenuto',
                'de' => 'Inhaltsvorschau',
                'es_MX' => 'Vista previa del contenido',
                'es' => 'Vista previa del contenido',
                'sv' => 'Innehållsförhandsgranskning',
                'pl' => 'Podgląd treści',
                'et' => 'Sisu eelvaade'
            ],
            'source' => [
                'en' => 'Source',
                'lt' => 'Šaltinis',
                'it' => 'Origine',
                'de' => 'Quelle',
                'es_MX' => 'Origen',
                'es' => 'Origen',
                'sv' => 'Källa',
                'pl' => 'Źródło',
                'et' => 'Allikas'
            ],
            'page_url' => [
                'en' => 'Page URL',
                'lt' => 'Puslapio URL',
                'it' => 'URL pagina',
                'de' => 'Seiten-URL',
                'es_MX' => 'URL de página',
                'es' => 'URL de página',
                'sv' => 'Sidans URL',
                'pl' => 'URL strony',
                'et' => 'Lehe URL'
            ],
            'ip_address' => [
                'en' => 'IP Address',
                'lt' => 'IP adresas',
                'it' => 'Indirizzo IP',
                'de' => 'IP-Adresse',
                'es_MX' => 'Dirección IP',
                'es' => 'Dirección IP',
                'sv' => 'IP-adress',
                'pl' => 'Adres IP',
                'et' => 'IP-aadress'
            ],
            'time' => [
                'en' => 'Time',
                'lt' => 'Laikas',
                'it' => 'Ora',
                'de' => 'Zeit',
                'es_MX' => 'Hora',
                'es' => 'Hora',
                'sv' => 'Tid',
                'pl' => 'Czas',
                'et' => 'Aeg'
            ],
            'actions' => [
                'en' => 'Actions',
                'lt' => 'Veiksmai',
                'it' => 'Azioni',
                'de' => 'Aktionen',
                'es_MX' => 'Acciones',
                'es' => 'Acciones',
                'sv' => 'Åtgärder',
                'pl' => 'Działania',
                'et' => 'Tegevused'
            ],
            'view' => [
                'en' => 'View',
                'lt' => 'Peržiūrėti',
                'it' => 'Visualizza',
                'de' => 'Ansehen',
                'es_MX' => 'Ver',
                'es' => 'Ver',
                'sv' => 'Visa',
                'pl' => 'Zobacz',
                'et' => 'Vaata'
            ],
            'delete' => [
                'en' => 'Delete',
                'lt' => 'Ištrinti',
                'it' => 'Elimina',
                'de' => 'Löschen',
                'es_MX' => 'Eliminar',
                'es' => 'Eliminar',
                'sv' => 'Radera',
                'pl' => 'Usuń',
                'et' => 'Kustuta'
            ],
            'submission_content' => [
                'en' => 'Submission Content',
                'lt' => 'Pateikimo turinys',
                'it' => 'Contenuto invio',
                'de' => 'Einreichungsinhalt',
                'es_MX' => 'Contenido del envío',
                'es' => 'Contenido del envío',
                'sv' => 'Inskickningsinnehåll',
                'pl' => 'Treść zgłoszenia',
                'et' => 'Esituse sisu'
            ],
            'previous' => [
                'en' => 'Previous',
                'lt' => 'Ankstesnis',
                'it' => 'Precedente',
                'de' => 'Zurück',
                'es_MX' => 'Anterior',
                'es' => 'Anterior',
                'sv' => 'Föregående',
                'pl' => 'Poprzedni',
                'et' => 'Eelmine'
            ],
            'next' => [
                'en' => 'Next',
                'lt' => 'Kitas',
                'it' => 'Successivo',
                'de' => 'Weiter',
                'es_MX' => 'Siguiente',
                'es' => 'Siguiente',
                'sv' => 'Nästa',
                'pl' => 'Następny',
                'et' => 'Järgmine'
            ],
            'page_of' => [
                'en' => 'Page %d of %d',
                'lt' => 'Puslapis %d iš %d',
                'it' => 'Pagina %d di %d',
                'de' => 'Seite %d von %d',
                'es_MX' => 'Página %d de %d',
                'es' => 'Página %d de %d',
                'sv' => 'Sida %d av %d',
                'pl' => 'Strona %d z %d',
                'et' => 'Leht %d / %d'
            ],
            'ago' => [
                'en' => 'ago',
                'lt' => 'prieš',
                'it' => 'fa',
                'de' => 'vor',
                'es_MX' => 'hace',
                'es' => 'hace',
                'sv' => 'sedan',
                'pl' => 'temu',
                'et' => 'tagasi'
            ],
            'no_issues' => [
                'en' => 'No issues detected',
                'lt' => 'Problemų neaptikta',
                'it' => 'Nessun problema rilevato',
                'de' => 'Keine Probleme erkannt',
                'es_MX' => 'No se detectaron problemas',
                'es' => 'No se detectaron problemas',
                'sv' => 'Inga problem upptäckta',
                'pl' => 'Nie wykryto problemów',
                'et' => 'Probleeme ei tuvastatud'
            ],

            // =====================================================
            // BLACKLIST PAGE
            // =====================================================
            'blacklist_title' => [
                'en' => 'Blacklist Management',
                'lt' => 'Juodųjų sąrašų valdymas',
                'it' => 'Gestione lista nera',
                'de' => 'Sperrlisten-Verwaltung',
                'es_MX' => 'Gestión de listas negras',
                'es' => 'Gestión de listas negras',
                'sv' => 'Svartlistehantering',
                'pl' => 'Zarządzanie czarną listą',
                'et' => 'Mustade nimekirjade haldus'
            ],
            'blacklist_subtitle' => [
                'en' => 'Manage blocked emails, domains, IPs and keywords',
                'lt' => 'Valdykite užblokuotus el. paštus, domenus, IP ir raktažodžius',
                'it' => 'Gestisci email, domini, IP e parole chiave bloccati',
                'de' => 'Verwalten Sie gesperrte E-Mails, Domains, IPs und Schlüsselwörter',
                'es_MX' => 'Gestiona emails, dominios, IPs y palabras clave bloqueados',
                'es' => 'Gestiona emails, dominios, IPs y palabras clave bloqueados',
                'sv' => 'Hantera blockerade e-postadresser, domäner, IP-adresser och nyckelord',
                'pl' => 'Zarządzaj zablokowanymi emailami, domenami, IP i słowami kluczowymi',
                'et' => 'Hallake blokeeritud e-poste, domeene, IP-sid ja võtmesõnu'
            ],
            'add_to_blacklist' => [
                'en' => 'Add to Blacklist',
                'lt' => 'Pridėti į juodąjį sąrašą',
                'it' => 'Aggiungi alla lista nera',
                'de' => 'Zur Sperrliste hinzufügen',
                'es_MX' => 'Agregar a lista negra',
                'es' => 'Agregar a lista negra',
                'sv' => 'Lägg till i svartlistan',
                'pl' => 'Dodaj do czarnej listy',
                'et' => 'Lisa musta nimekirja'
            ],
            'type' => [
                'en' => 'Type',
                'lt' => 'Tipas',
                'it' => 'Tipo',
                'de' => 'Typ',
                'es_MX' => 'Tipo',
                'es' => 'Tipo',
                'sv' => 'Typ',
                'pl' => 'Typ',
                'et' => 'Tüüp'
            ],
            'value' => [
                'en' => 'Value',
                'lt' => 'Reikšmė',
                'it' => 'Valore',
                'de' => 'Wert',
                'es_MX' => 'Valor',
                'es' => 'Valor',
                'sv' => 'Värde',
                'pl' => 'Wartość',
                'et' => 'Väärtus'
            ],
            'hits' => [
                'en' => 'Hits',
                'lt' => 'Pataikymai',
                'it' => 'Occorrenze',
                'de' => 'Treffer',
                'es_MX' => 'Ocurrencias',
                'es' => 'Ocurrencias',
                'sv' => 'Träffar',
                'pl' => 'Trafienia',
                'et' => 'Tabamused'
            ],
            'added' => [
                'en' => 'Added',
                'lt' => 'Pridėta',
                'it' => 'Aggiunto',
                'de' => 'Hinzugefügt',
                'es_MX' => 'Agregado',
                'es' => 'Agregado',
                'sv' => 'Tillagd',
                'pl' => 'Dodano',
                'et' => 'Lisatud'
            ],
            'email' => [
                'en' => 'Email',
                'lt' => 'El. paštas',
                'it' => 'Email',
                'de' => 'E-Mail',
                'es_MX' => 'Correo',
                'es' => 'Correo',
                'sv' => 'E-post',
                'pl' => 'Email',
                'et' => 'E-post'
            ],
            'domain' => [
                'en' => 'Domain',
                'lt' => 'Domenas',
                'it' => 'Dominio',
                'de' => 'Domain',
                'es_MX' => 'Dominio',
                'es' => 'Dominio',
                'sv' => 'Domän',
                'pl' => 'Domena',
                'et' => 'Domeen'
            ],
            'ip' => [
                'en' => 'IP',
                'lt' => 'IP',
                'it' => 'IP',
                'de' => 'IP',
                'es_MX' => 'IP',
                'es' => 'IP',
                'sv' => 'IP',
                'pl' => 'IP',
                'et' => 'IP'
            ],
            'keyword' => [
                'en' => 'Keyword',
                'lt' => 'Raktažodis',
                'it' => 'Parola chiave',
                'de' => 'Schlüsselwort',
                'es_MX' => 'Palabra clave',
                'es' => 'Palabra clave',
                'sv' => 'Nyckelord',
                'pl' => 'Słowo kluczowe',
                'et' => 'Võtmesõna'
            ],
            'no_blacklist_entries' => [
                'en' => 'No blacklist entries yet.',
                'lt' => 'Dar nėra įrašų juodajame sąraše.',
                'it' => 'Nessuna voce nella lista nera.',
                'de' => 'Noch keine Sperrlisteneinträge.',
                'es_MX' => 'Aún no hay entradas en la lista negra.',
                'es' => 'Aún no hay entradas en la lista negra.',
                'sv' => 'Inga svartlisteposter än.',
                'pl' => 'Brak wpisów na czarnej liście.',
                'et' => 'Mustas nimekirjas pole veel kirjeid.'
            ],

            // =====================================================
            // CONFIRMATIONS & MESSAGES
            // =====================================================
            'confirm_delete' => [
                'en' => 'Are you sure you want to delete this entry?',
                'lt' => 'Ar tikrai norite ištrinti šį įrašą?',
                'it' => 'Sei sicuro di voler eliminare questa voce?',
                'de' => 'Sind Sie sicher, dass Sie diesen Eintrag löschen möchten?',
                'es_MX' => '¿Estás seguro de que deseas eliminar esta entrada?',
                'es' => '¿Estás seguro de que deseas eliminar esta entrada?',
                'sv' => 'Är du säker på att du vill radera denna post?',
                'pl' => 'Czy na pewno chcesz usunąć ten wpis?',
                'et' => 'Kas olete kindel, et soovite selle kirje kustutada?'
            ],
            'confirm_clear_logs' => [
                'en' => 'Are you sure you want to clear all logs?',
                'lt' => 'Ar tikrai norite išvalyti visus žurnalus?',
                'it' => 'Sei sicuro di voler cancellare tutti i registri?',
                'de' => 'Sind Sie sicher, dass Sie alle Protokolle löschen möchten?',
                'es_MX' => '¿Estás seguro de que deseas borrar todos los registros?',
                'es' => '¿Estás seguro de que deseas borrar todos los registros?',
                'sv' => 'Är du säker på att du vill rensa alla loggar?',
                'pl' => 'Czy na pewno chcesz wyczyścić wszystkie logi?',
                'et' => 'Kas olete kindel, et soovite kõik logid tühjendada?'
            ],
            'entry_deleted' => [
                'en' => 'Entry deleted.',
                'lt' => 'Įrašas ištrintas.',
                'it' => 'Voce eliminata.',
                'de' => 'Eintrag gelöscht.',
                'es_MX' => 'Entrada eliminada.',
                'es' => 'Entrada eliminada.',
                'sv' => 'Post raderad.',
                'pl' => 'Wpis usunięty.',
                'et' => 'Kirje kustutatud.'
            ],
            'logs_cleared' => [
                'en' => 'Logs cleared.',
                'lt' => 'Žurnalai išvalyti.',
                'it' => 'Registri cancellati.',
                'de' => 'Protokolle gelöscht.',
                'es_MX' => 'Registros borrados.',
                'es' => 'Registros borrados.',
                'sv' => 'Loggar rensade.',
                'pl' => 'Logi wyczyszczone.',
                'et' => 'Logid tühjendatud.'
            ],
            'added_to_blacklist' => [
                'en' => 'Entry added to blacklist.',
                'lt' => 'Įrašas pridėtas į juodąjį sąrašą.',
                'it' => 'Voce aggiunta alla lista nera.',
                'de' => 'Eintrag zur Sperrliste hinzugefügt.',
                'es_MX' => 'Entrada agregada a la lista negra.',
                'es' => 'Entrada agregada a la lista negra.',
                'sv' => 'Post tillagd i svartlistan.',
                'pl' => 'Wpis dodany do czarnej listy.',
                'et' => 'Kirje lisatud musta nimekirja.'
            ],
            'add_ip_to_blacklist' => [
                'en' => 'Add IP to blacklist',
                'lt' => 'Pridėti IP į juodąjį sąrašą',
                'it' => 'Aggiungi IP alla lista nera',
                'de' => 'IP zur Sperrliste hinzufügen',
                'es_MX' => 'Agregar IP a la lista negra',
                'es' => 'Agregar IP a la lista negra',
                'sv' => 'Lägg till IP i svartlistan',
                'pl' => 'Dodaj IP do czarnej listy',
                'et' => 'Lisa IP musta nimekirja'
            ],
            'confirm_blacklist_ip' => [
                'en' => 'Are you sure you want to blacklist IP',
                'lt' => 'Ar tikrai norite užblokuoti IP',
                'it' => 'Sei sicuro di voler bloccare l\'IP',
                'de' => 'Sind Sie sicher, dass Sie die IP sperren möchten',
                'es_MX' => '¿Estás seguro de que deseas bloquear la IP',
                'es' => '¿Estás seguro de que deseas bloquear la IP',
                'sv' => 'Är du säker på att du vill svartlista IP',
                'pl' => 'Czy na pewno chcesz zablokować IP',
                'et' => 'Kas olete kindel, et soovite musta nimekirja lisada IP'
            ],
            'added_from_spam_logs' => [
                'en' => 'Added from spam logs',
                'lt' => 'Pridėta iš šlamšto žurnalų',
                'it' => 'Aggiunto dai log spam',
                'de' => 'Aus Spam-Protokollen hinzugefügt',
                'es_MX' => 'Agregado desde registros de spam',
                'es' => 'Agregado desde registros de spam',
                'sv' => 'Tillagd från skräppostloggar',
                'pl' => 'Dodano z logów spamu',
                'et' => 'Lisatud rämpspostilogidest'
            ],
            'ip_blacklisted' => [
                'en' => 'IP blacklisted',
                'lt' => 'IP užblokuotas',
                'it' => 'IP bloccato',
                'de' => 'IP gesperrt',
                'es_MX' => 'IP bloqueada',
                'es' => 'IP bloqueada',
                'sv' => 'IP svartlistad',
                'pl' => 'IP zablokowany',
                'et' => 'IP mustas nimekirjas'
            ],
            'remove_ip_from_blacklist' => [
                'en' => 'Remove IP from blacklist',
                'lt' => 'Pašalinti IP iš juodojo sąrašo',
                'it' => 'Rimuovi IP dalla lista nera',
                'de' => 'IP aus Sperrliste entfernen',
                'es_MX' => 'Eliminar IP de la lista negra',
                'es' => 'Eliminar IP de la lista negra',
                'sv' => 'Ta bort IP från svartlistan',
                'pl' => 'Usuń IP z czarnej listy',
                'et' => 'Eemalda IP mustast nimekirjast'
            ],
            'confirm_unblacklist_ip' => [
                'en' => 'Are you sure you want to unblock IP',
                'lt' => 'Ar tikrai norite atblokuoti IP',
                'it' => 'Sei sicuro di voler sbloccare l\'IP',
                'de' => 'Sind Sie sicher, dass Sie die IP entsperren möchten',
                'es_MX' => '¿Estás seguro de que deseas desbloquear la IP',
                'es' => '¿Estás seguro de que deseas desbloquear la IP',
                'sv' => 'Är du säker på att du vill avblockera IP',
                'pl' => 'Czy na pewno chcesz odblokować IP',
                'et' => 'Kas olete kindel, et soovite IP blokeeringu eemaldada'
            ],
            'error_occurred' => [
                'en' => 'An error occurred.',
                'lt' => 'Įvyko klaida.',
                'it' => 'Si è verificato un errore.',
                'de' => 'Ein Fehler ist aufgetreten.',
                'es_MX' => 'Ocurrió un error.',
                'es' => 'Ocurrió un error.',
                'sv' => 'Ett fel inträffade.',
                'pl' => 'Wystąpił błąd.',
                'et' => 'Tekkis viga.'
            ],

            // =====================================================
            // FOOTER
            // =====================================================
            'need_help' => [
                'en' => 'Need advanced protection or custom development?',
                'lt' => 'Reikia pažangios apsaugos ar individualaus kūrimo?',
                'it' => 'Hai bisogno di protezione avanzata o sviluppo personalizzato?',
                'de' => 'Benötigen Sie erweiterten Schutz oder individuelle Entwicklung?',
                'es_MX' => '¿Necesitas protección avanzada o desarrollo personalizado?',
                'es' => '¿Necesitas protección avanzada o desarrollo personalizado?',
                'sv' => 'Behöver du avancerat skydd eller anpassad utveckling?',
                'pl' => 'Potrzebujesz zaawansowanej ochrony lub niestandardowego rozwoju?',
                'et' => 'Vajate täiustatud kaitset või kohandatud arendust?'
            ],
            'visit_website' => [
                'en' => 'Visit www.mantasdigital.com',
                'lt' => 'Aplankykite md.lt',
                'it' => 'Visita www.mantasdigital.com',
                'de' => 'Besuchen Sie www.mantasdigital.com',
                'es_MX' => 'Visita www.mantasdigital.com',
                'es' => 'Visita www.mantasdigital.com',
                'sv' => 'Besök www.mantasdigital.com',
                'pl' => 'Odwiedź www.mantasdigital.com',
                'et' => 'Külastage www.mantasdigital.com'
            ],

            // =====================================================
            // SPAM MESSAGES (shown to end users)
            // =====================================================
            'spam_message_en' => [
                'en' => 'Your submission has been flagged as spam. Please try again or contact us directly.',
                'lt' => 'Jūsų pateikimas pažymėtas kaip šlamštas. Bandykite dar kartą arba susisiekite su mumis tiesiogiai.',
                'it' => 'Il tuo invio è stato contrassegnato come spam. Riprova o contattaci direttamente.',
                'de' => 'Ihre Einreichung wurde als Spam markiert. Bitte versuchen Sie es erneut oder kontaktieren Sie uns direkt.',
                'es_MX' => 'Tu envío ha sido marcado como spam. Por favor intenta de nuevo o contáctanos directamente.',
                'es' => 'Tu envío ha sido marcado como spam. Por favor intenta de nuevo o contáctanos directamente.',
                'sv' => 'Din inskickning har flaggats som skräppost. Försök igen eller kontakta oss direkt.',
                'pl' => 'Twoje zgłoszenie zostało oznaczone jako spam. Spróbuj ponownie lub skontaktuj się z nami bezpośrednio.',
                'et' => 'Teie esitus on märgitud rämpspostiks. Proovige uuesti või võtke meiega otse ühendust.'
            ],

            // =====================================================
            // ADDITIONAL SETTINGS PAGE TRANSLATIONS
            // =====================================================

            // Honeypot additional
            'custom_field_name' => [
                'en' => 'Custom Field Name',
                'lt' => 'Pasirinktinis lauko pavadinimas',
                'it' => 'Nome campo personalizzato',
                'de' => 'Benutzerdefinierter Feldname',
                'es_MX' => 'Nombre de campo personalizado',
                'es' => 'Nombre de campo personalizado',
                'sv' => 'Anpassat fältnamn',
                'pl' => 'Niestandardowa nazwa pola',
                'et' => 'Kohandatud välja nimi'
            ],
            'additional_field_names' => [
                'en' => 'Additional Field Names (one per line)',
                'lt' => 'Papildomi laukų pavadinimai (po vieną eilutėje)',
                'it' => 'Nomi campi aggiuntivi (uno per riga)',
                'de' => 'Zusätzliche Feldnamen (einer pro Zeile)',
                'es_MX' => 'Nombres de campos adicionales (uno por línea)',
                'es' => 'Nombres de campos adicionales (uno por línea)',
                'sv' => 'Ytterligare fältnamn (ett per rad)',
                'pl' => 'Dodatkowe nazwy pól (jedna na linię)',
                'et' => 'Täiendavad väljanimede (üks rea kohta)'
            ],
            'additional_names_description' => [
                'en' => 'Add your own realistic field names to the rotation pool.',
                'lt' => 'Pridėkite savo realistiškus laukų pavadinimus į rotacijos fondą.',
                'it' => 'Aggiungi i tuoi nomi di campo realistici al pool di rotazione.',
                'de' => 'Fügen Sie Ihre eigenen realistischen Feldnamen zum Rotationspool hinzu.',
                'es_MX' => 'Agrega tus propios nombres de campo realistas al grupo de rotación.',
                'es' => 'Agrega tus propios nombres de campo realistas al grupo de rotación.',
                'sv' => 'Lägg till dina egna realistiska fältnamn i rotationspoolen.',
                'pl' => 'Dodaj własne realistyczne nazwy pól do puli rotacji.',
                'et' => 'Lisage oma realistlikud väljanimed rotatsioonifondi.'
            ],
            'inject_via_js' => [
                'en' => 'Inject via JavaScript',
                'lt' => 'Įterpti per JavaScript',
                'it' => 'Inietta tramite JavaScript',
                'de' => 'Per JavaScript einfügen',
                'es_MX' => 'Inyectar vía JavaScript',
                'es' => 'Inyectar vía JavaScript',
                'sv' => 'Injicera via JavaScript',
                'pl' => 'Wstrzykuj przez JavaScript',
                'et' => 'Süsti JavaScripti kaudu'
            ],

            // Registration Protection
            'wp_registration' => [
                'en' => 'WordPress Registration',
                'lt' => 'WordPress registracija',
                'it' => 'Registrazione WordPress',
                'de' => 'WordPress-Registrierung',
                'es_MX' => 'Registro de WordPress',
                'es' => 'Registro de WordPress',
                'sv' => 'WordPress-registrering',
                'pl' => 'Rejestracja WordPress',
                'et' => 'WordPressi registreerimine'
            ],
            'woo_account_registration' => [
                'en' => 'WooCommerce Account Registration',
                'lt' => 'WooCommerce paskyros registracija',
                'it' => 'Registrazione account WooCommerce',
                'de' => 'WooCommerce-Kontoregistrierung',
                'es_MX' => 'Registro de cuenta WooCommerce',
                'es' => 'Registro de cuenta WooCommerce',
                'sv' => 'WooCommerce-kontoregistrering',
                'pl' => 'Rejestracja konta WooCommerce',
                'et' => 'WooCommerce konto registreerimine'
            ],
            'woo_checkout_registration' => [
                'en' => 'WooCommerce Checkout Registration',
                'lt' => 'WooCommerce atsiskaitymo registracija',
                'it' => 'Registrazione checkout WooCommerce',
                'de' => 'WooCommerce-Checkout-Registrierung',
                'es_MX' => 'Registro en checkout de WooCommerce',
                'es' => 'Registro en checkout de WooCommerce',
                'sv' => 'WooCommerce-kassaregistrering',
                'pl' => 'Rejestracja przy kasie WooCommerce',
                'et' => 'WooCommerce kassa registreerimine'
            ],

            // Keywords
            'block_if_subject_contains' => [
                'en' => 'Block if Subject Contains (one per line)',
                'lt' => 'Blokuoti, jei tema turi (po vieną eilutėje)',
                'it' => 'Blocca se oggetto contiene (uno per riga)',
                'de' => 'Blockieren wenn Betreff enthält (eines pro Zeile)',
                'es_MX' => 'Bloquear si el asunto contiene (uno por línea)',
                'es' => 'Bloquear si el asunto contiene (uno por línea)',
                'sv' => 'Blockera om ämnet innehåller (ett per rad)',
                'pl' => 'Blokuj jeśli temat zawiera (jeden na linię)',
                'et' => 'Blokeeri kui teema sisaldab (üks rea kohta)'
            ],
            'block_if_body_contains' => [
                'en' => 'Block if Body Contains (one per line)',
                'lt' => 'Blokuoti, jei turinys turi (po vieną eilutėje)',
                'it' => 'Blocca se corpo contiene (uno per riga)',
                'de' => 'Blockieren wenn Text enthält (eines pro Zeile)',
                'es_MX' => 'Bloquear si el cuerpo contiene (uno por línea)',
                'es' => 'Bloquear si el cuerpo contiene (uno por línea)',
                'sv' => 'Blockera om brödtexten innehåller (ett per rad)',
                'pl' => 'Blokuj jeśli treść zawiera (jeden na linię)',
                'et' => 'Blokeeri kui sisu sisaldab (üks rea kohta)'
            ],
            'block_if_any_contains' => [
                'en' => 'Block if ANY Field Contains (one per line)',
                'lt' => 'Blokuoti, jei BET KURIS laukas turi (po vieną eilutėje)',
                'it' => 'Blocca se QUALSIASI campo contiene (uno per riga)',
                'de' => 'Blockieren wenn IRGENDEIN Feld enthält (eines pro Zeile)',
                'es_MX' => 'Bloquear si CUALQUIER campo contiene (uno por línea)',
                'es' => 'Bloquear si CUALQUIER campo contiene (uno por línea)',
                'sv' => 'Blockera om NÅGOT fält innehåller (ett per rad)',
                'pl' => 'Blokuj jeśli JAKIEKOLWIEK pole zawiera (jeden na linię)',
                'et' => 'Blokeeri kui ÜKSKÕIK MILLINE väli sisaldab (üks rea kohta)'
            ],

            // Heuristics
            'smart_detection' => [
                'en' => 'Smart Detection',
                'lt' => 'Išmanus aptikimas',
                'it' => 'Rilevamento intelligente',
                'de' => 'Intelligente Erkennung',
                'es_MX' => 'Detección inteligente',
                'es' => 'Detección inteligente',
                'sv' => 'Smart detektering',
                'pl' => 'Inteligentne wykrywanie',
                'et' => 'Nutikas tuvastamine'
            ],
            'enable_heuristic' => [
                'en' => 'Enable Heuristic Analysis',
                'lt' => 'Įjungti euristinę analizę',
                'it' => 'Abilita analisi euristica',
                'de' => 'Heuristische Analyse aktivieren',
                'es_MX' => 'Habilitar análisis heurístico',
                'es' => 'Habilitar análisis heurístico',
                'sv' => 'Aktivera heuristisk analys',
                'pl' => 'Włącz analizę heurystyczną',
                'et' => 'Luba heuristiline analüüs'
            ],
            'max_links_allowed' => [
                'en' => 'Max Links Allowed',
                'lt' => 'Maks. leidžiamų nuorodų',
                'it' => 'Link massimi consentiti',
                'de' => 'Max. erlaubte Links',
                'es_MX' => 'Máximo de enlaces permitidos',
                'es' => 'Máximo de enlaces permitidos',
                'sv' => 'Max tillåtna länkar',
                'pl' => 'Maks. dozwolonych linków',
                'et' => 'Max lubatud linke'
            ],

            // Security
            'security' => [
                'en' => 'Security',
                'lt' => 'Saugumas',
                'it' => 'Sicurezza',
                'de' => 'Sicherheit',
                'es_MX' => 'Seguridad',
                'es' => 'Seguridad',
                'sv' => 'Säkerhet',
                'pl' => 'Bezpieczeństwo',
                'et' => 'Turvalisus'
            ],
            'require_referer' => [
                'en' => 'Require HTTP Referer',
                'lt' => 'Reikalauti HTTP Referer',
                'it' => 'Richiedi HTTP Referer',
                'de' => 'HTTP Referer erforderlich',
                'es_MX' => 'Requerir HTTP Referer',
                'es' => 'Requerir HTTP Referer',
                'sv' => 'Kräv HTTP Referer',
                'pl' => 'Wymagaj HTTP Referer',
                'et' => 'Nõua HTTP Refererit'
            ],
            'enable_cookie_check' => [
                'en' => 'Enable Cookie Verification',
                'lt' => 'Įjungti slapukų tikrinimą',
                'it' => 'Abilita verifica cookie',
                'de' => 'Cookie-Überprüfung aktivieren',
                'es_MX' => 'Habilitar verificación de cookies',
                'es' => 'Habilitar verificación de cookies',
                'sv' => 'Aktivera cookie-verifiering',
                'pl' => 'Włącz weryfikację plików cookie',
                'et' => 'Luba küpsiste kontrollimine'
            ],
            'cookie_check_description' => [
                'en' => 'Requires a verification cookie set by JavaScript. Blocks bots that don\'t execute JavaScript.',
                'lt' => 'Reikalauja patvirtinimo slapuko, nustatyto JavaScript. Blokuoja robotus, kurie nevykdo JavaScript.',
                'it' => 'Richiede un cookie di verifica impostato da JavaScript. Blocca i bot che non eseguono JavaScript.',
                'de' => 'Erfordert ein von JavaScript gesetztes Verifizierungs-Cookie. Blockiert Bots, die kein JavaScript ausführen.',
                'es_MX' => 'Requiere una cookie de verificación establecida por JavaScript. Bloquea bots que no ejecutan JavaScript.',
                'es' => 'Requiere una cookie de verificación establecida por JavaScript. Bloquea bots que no ejecutan JavaScript.',
                'sv' => 'Kräver en verifieringscookie inställd av JavaScript. Blockerar botar som inte kör JavaScript.',
                'pl' => 'Wymaga pliku cookie weryfikacyjnego ustawionego przez JavaScript. Blokuje boty, które nie wykonują JavaScript.',
                'et' => 'Nõuab JavaScripti poolt seatud kinnitusküpsist. Blokeerib roboteid, mis JavaScripti ei käivita.'
            ],
            'whitelist_admins' => [
                'en' => 'Whitelist Logged-in Admins',
                'lt' => 'Leisti prisijungusius administratorius',
                'it' => 'Whitelist admin connessi',
                'de' => 'Angemeldete Admins auf Whitelist',
                'es_MX' => 'Permitir admins conectados',
                'es' => 'Permitir admins conectados',
                'sv' => 'Vitlista inloggade admins',
                'pl' => 'Białą listą zalogowanych adminów',
                'et' => 'Luba sisselogitud administraatorid'
            ],
            'note' => [
                'en' => 'Note',
                'lt' => 'Pastaba',
                'it' => 'Nota',
                'de' => 'Hinweis',
                'es_MX' => 'Nota',
                'es' => 'Nota',
                'sv' => 'Not',
                'pl' => 'Uwaga',
                'et' => 'Märkus'
            ],
            'whitelist_admins_note' => [
                'en' => 'When enabled, spam checks are SKIPPED for logged-in administrators. To test spam detection, either disable this option or test in a private/incognito browser window.',
                'lt' => 'Įjungus, šlamšto tikrinimai PRALEIDŽIAMI prisijungusiems administratoriams. Norėdami išbandyti šlamšto aptikimą, išjunkite šią parinktį arba išbandykite privačiame/inkognito naršyklės lange.',
                'it' => 'Se abilitato, i controlli spam vengono SALTATI per gli amministratori connessi. Per testare il rilevamento spam, disabilita questa opzione o testa in una finestra del browser privata/incognito.',
                'de' => 'Wenn aktiviert, werden Spam-Prüfungen für angemeldete Administratoren ÜBERSPRUNGEN. Um die Spam-Erkennung zu testen, deaktivieren Sie diese Option oder testen Sie in einem privaten/Inkognito-Browserfenster.',
                'es_MX' => 'Cuando está habilitado, las verificaciones de spam se OMITEN para los administradores conectados. Para probar la detección de spam, desactiva esta opción o prueba en una ventana de navegador privada/incógnito.',
                'es' => 'Cuando está habilitado, las verificaciones de spam se OMITEN para los administradores conectados. Para probar la detección de spam, desactiva esta opción o prueba en una ventana de navegador privada/incógnito.',
                'sv' => 'När aktiverat HOPPAS spamkontroller över för inloggade administratörer. För att testa spam-detektering, inaktivera detta alternativ eller testa i ett privat/inkognito-webbläsarfönster.',
                'pl' => 'Po włączeniu sprawdzanie spamu jest POMIJANE dla zalogowanych administratorów. Aby przetestować wykrywanie spamu, wyłącz tę opcję lub testuj w prywatnym/incognito oknie przeglądarki.',
                'et' => 'Kui see on lubatud, JÄETAKSE sisselogitud administraatorite puhul rämpsposti kontrollid vahele. Rämpsposti tuvastamise testimiseks keelake see valik või testige privaatses/inkognito brauseriaknas.'
            ],

            // Logging
            'logging' => [
                'en' => 'Logging',
                'lt' => 'Žurnalizavimas',
                'it' => 'Registrazione',
                'de' => 'Protokollierung',
                'es_MX' => 'Registro',
                'es' => 'Registro',
                'sv' => 'Loggning',
                'pl' => 'Logowanie',
                'et' => 'Logimine'
            ],
            'retention_days' => [
                'en' => 'Retention (days)',
                'lt' => 'Saugojimas (dienomis)',
                'it' => 'Conservazione (giorni)',
                'de' => 'Aufbewahrung (Tage)',
                'es_MX' => 'Retención (días)',
                'es' => 'Retención (días)',
                'sv' => 'Lagring (dagar)',
                'pl' => 'Przechowywanie (dni)',
                'et' => 'Säilitamine (päevades)'
            ],

            // Escalation
            'escalation' => [
                'en' => 'Escalation',
                'lt' => 'Eskalacija',
                'it' => 'Escalation',
                'de' => 'Eskalation',
                'es_MX' => 'Escalación',
                'es' => 'Escalación',
                'sv' => 'Eskalering',
                'pl' => 'Eskalacja',
                'et' => 'Eskalatsioon'
            ],
            'alert_after' => [
                'en' => 'Alert After',
                'lt' => 'Įspėti po',
                'it' => 'Avvisa dopo',
                'de' => 'Warnung nach',
                'es_MX' => 'Alertar después de',
                'es' => 'Alertar después de',
                'sv' => 'Varna efter',
                'pl' => 'Ostrzeż po',
                'et' => 'Hoiata pärast'
            ],
            'spam_submissions' => [
                'en' => 'spam submissions',
                'lt' => 'šlamšto pateikimų',
                'it' => 'invii spam',
                'de' => 'Spam-Einreichungen',
                'es_MX' => 'envíos de spam',
                'es' => 'envíos de spam',
                'sv' => 'skräppostinskickningar',
                'pl' => 'zgłoszeń spamu',
                'et' => 'rämpsposti esitust'
            ],
            'within' => [
                'en' => 'Within',
                'lt' => 'Per',
                'it' => 'Entro',
                'de' => 'Innerhalb',
                'es_MX' => 'Dentro de',
                'es' => 'Dentro de',
                'sv' => 'Inom',
                'pl' => 'W ciągu',
                'et' => 'Jooksul'
            ],
            'minutes' => [
                'en' => 'minutes',
                'lt' => 'minučių',
                'it' => 'minuti',
                'de' => 'Minuten',
                'es_MX' => 'minutos',
                'es' => 'minutos',
                'sv' => 'minuter',
                'pl' => 'minut',
                'et' => 'minutit'
            ],

            // AI Gibberish Detection
            'ai_gibberish_detection' => [
                'en' => 'AI Gibberish Detection',
                'lt' => 'AI nesąmonių aptikimas',
                'it' => 'Rilevamento AI testo senza senso',
                'de' => 'KI-Unsinnserkennung',
                'es_MX' => 'Detección de texto sin sentido con IA',
                'es' => 'Detección de texto sin sentido con IA',
                'sv' => 'AI-detektering av nonsens',
                'pl' => 'Wykrywanie bełkotu AI',
                'et' => 'Tehisintellekti mõttetu teksti tuvastamine'
            ],
            'ai_powered' => [
                'en' => 'AI Powered',
                'lt' => 'AI valdomas',
                'it' => 'Alimentato da AI',
                'de' => 'KI-gestützt',
                'es_MX' => 'Impulsado por IA',
                'es' => 'Impulsado por IA',
                'sv' => 'AI-driven',
                'pl' => 'Napędzany przez AI',
                'et' => 'Tehisintellekti toega'
            ],
            'ai_gibberish_description' => [
                'en' => 'Uses AI to detect random/nonsensical text that bots often generate. Requires your own API key.',
                'lt' => 'Naudoja AI atsitiktiniam/beprasmiam tekstui, kurį dažnai generuoja botai, aptikti. Reikalingas jūsų API raktas.',
                'it' => 'Utilizza l\'AI per rilevare testo casuale/senza senso che i bot spesso generano. Richiede la tua chiave API.',
                'de' => 'Verwendet KI, um zufälligen/unsinnigen Text zu erkennen, den Bots oft generieren. Erfordert Ihren eigenen API-Schlüssel.',
                'es_MX' => 'Usa IA para detectar texto aleatorio/sin sentido que los bots generan frecuentemente. Requiere tu propia clave API.',
                'es' => 'Usa IA para detectar texto aleatorio/sin sentido que los bots generan frecuentemente. Requiere tu propia clave API.',
                'sv' => 'Använder AI för att upptäcka slumpmässig/meningslös text som botar ofta genererar. Kräver din egen API-nyckel.',
                'pl' => 'Używa AI do wykrywania losowego/bezsensownego tekstu, który często generują boty. Wymaga własnego klucza API.',
                'et' => 'Kasutab tehisintellekti juhusliku/mõttetu teksti tuvastamiseks, mida robotid sageli genereerivad. Nõuab teie enda API võtit.'
            ],
            'enable_ai_gibberish' => [
                'en' => 'Enable AI Gibberish Detection',
                'lt' => 'Įjungti AI nesąmonių aptikimą',
                'it' => 'Abilita rilevamento AI testo senza senso',
                'de' => 'KI-Unsinnserkennung aktivieren',
                'es_MX' => 'Habilitar detección de texto sin sentido con IA',
                'es' => 'Habilitar detección de texto sin sentido con IA',
                'sv' => 'Aktivera AI-detektering av nonsens',
                'pl' => 'Włącz wykrywanie bełkotu AI',
                'et' => 'Luba tehisintellekti mõttetu teksti tuvastamine'
            ],
            'ai_provider' => [
                'en' => 'AI Provider',
                'lt' => 'AI tiekėjas',
                'it' => 'Provider AI',
                'de' => 'KI-Anbieter',
                'es_MX' => 'Proveedor de IA',
                'es' => 'Proveedor de IA',
                'sv' => 'AI-leverantör',
                'pl' => 'Dostawca AI',
                'et' => 'Tehisintellekti pakkuja'
            ],
            'api_key' => [
                'en' => 'API Key',
                'lt' => 'API raktas',
                'it' => 'Chiave API',
                'de' => 'API-Schlüssel',
                'es_MX' => 'Clave API',
                'es' => 'Clave API',
                'sv' => 'API-nyckel',
                'pl' => 'Klucz API',
                'et' => 'API võti'
            ],
            'get_api_key_from' => [
                'en' => 'Get your API key from',
                'lt' => 'Gaukite savo API raktą iš',
                'it' => 'Ottieni la tua chiave API da',
                'de' => 'Holen Sie sich Ihren API-Schlüssel von',
                'es_MX' => 'Obtén tu clave API de',
                'es' => 'Obtén tu clave API de',
                'sv' => 'Hämta din API-nyckel från',
                'pl' => 'Pobierz swój klucz API z',
                'et' => 'Hankige oma API võti'
            ],
            'or' => [
                'en' => 'or',
                'lt' => 'arba',
                'it' => 'o',
                'de' => 'oder',
                'es_MX' => 'o',
                'es' => 'o',
                'sv' => 'eller',
                'pl' => 'lub',
                'et' => 'või'
            ],
            'default_language' => [
                'en' => 'Default Language',
                'lt' => 'Numatytoji kalba',
                'it' => 'Lingua predefinita',
                'de' => 'Standardsprache',
                'es_MX' => 'Idioma predeterminado',
                'es' => 'Idioma predeterminado',
                'sv' => 'Standardspråk',
                'pl' => 'Domyślny język',
                'et' => 'Vaikekeel'
            ],
            'auto_detect_wpml' => [
                'en' => 'Auto-detect (WPML/Polylang)',
                'lt' => 'Automatinis aptikimas (WPML/Polylang)',
                'it' => 'Rilevamento automatico (WPML/Polylang)',
                'de' => 'Automatische Erkennung (WPML/Polylang)',
                'es_MX' => 'Detección automática (WPML/Polylang)',
                'es' => 'Detección automática (WPML/Polylang)',
                'sv' => 'Automatisk detektering (WPML/Polylang)',
                'pl' => 'Automatyczne wykrywanie (WPML/Polylang)',
                'et' => 'Automaatne tuvastamine (WPML/Polylang)'
            ],
            'default_language_description' => [
                'en' => 'Fallback when no domain-specific language is set. Auto-detect works with WPML/Polylang.',
                'lt' => 'Atsarginė parinktis, kai nenustatyta domeno kalba. Automatinis aptikimas veikia su WPML/Polylang.',
                'it' => 'Fallback quando non è impostata una lingua specifica per dominio. Rilevamento automatico funziona con WPML/Polylang.',
                'de' => 'Fallback wenn keine domänenspezifische Sprache eingestellt ist. Automatische Erkennung funktioniert mit WPML/Polylang.',
                'es_MX' => 'Respaldo cuando no se establece idioma específico por dominio. La detección automática funciona con WPML/Polylang.',
                'es' => 'Respaldo cuando no se establece idioma específico por dominio. La detección automática funciona con WPML/Polylang.',
                'sv' => 'Reserv när inget domänspecifikt språk är inställt. Automatisk detektering fungerar med WPML/Polylang.',
                'pl' => 'Zapasowy gdy nie ustawiono języka dla domeny. Automatyczne wykrywanie działa z WPML/Polylang.',
                'et' => 'Varukeel kui domeenispetsiifilist keelt pole määratud. Automaatne tuvastamine töötab WPML/Polylangiga.'
            ],
            'per_domain_languages' => [
                'en' => 'Per-Domain Languages',
                'lt' => 'Kalbos pagal domeną',
                'it' => 'Lingue per dominio',
                'de' => 'Sprachen pro Domain',
                'es_MX' => 'Idiomas por dominio',
                'es' => 'Idiomas por dominio',
                'sv' => 'Språk per domän',
                'pl' => 'Języki dla domeny',
                'et' => 'Keeled domeeni kohta'
            ],
            'per_domain_languages_description' => [
                'en' => 'Set accepted languages for each domain. Supports multiple languages per domain.',
                'lt' => 'Nustatykite priimamas kalbas kiekvienam domenui. Palaiko kelias kalbas domenui.',
                'it' => 'Imposta le lingue accettate per ogni dominio. Supporta più lingue per dominio.',
                'de' => 'Legen Sie akzeptierte Sprachen für jede Domain fest. Unterstützt mehrere Sprachen pro Domain.',
                'es_MX' => 'Establece idiomas aceptados para cada dominio. Soporta múltiples idiomas por dominio.',
                'es' => 'Establece idiomas aceptados para cada dominio. Soporta múltiples idiomas por dominio.',
                'sv' => 'Ställ in accepterade språk för varje domän. Stöder flera språk per domän.',
                'pl' => 'Ustaw akceptowane języki dla każdej domeny. Obsługuje wiele języków dla domeny.',
                'et' => 'Määrake iga domeeni jaoks aktsepteeritud keeled. Toetab mitut keelt domeeni kohta.'
            ],
            'format' => [
                'en' => 'Format',
                'lt' => 'Formatas',
                'it' => 'Formato',
                'de' => 'Format',
                'es_MX' => 'Formato',
                'es' => 'Formato',
                'sv' => 'Format',
                'pl' => 'Format',
                'et' => 'Formaat'
            ],
            'examples' => [
                'en' => 'Examples',
                'lt' => 'Pavyzdžiai',
                'it' => 'Esempi',
                'de' => 'Beispiele',
                'es_MX' => 'Ejemplos',
                'es' => 'Ejemplos',
                'sv' => 'Exempel',
                'pl' => 'Przykłady',
                'et' => 'Näited'
            ],
            'accepts_lt_en' => [
                'en' => 'Accepts Lithuanian AND English',
                'lt' => 'Priima lietuvių IR anglų',
                'it' => 'Accetta lituano E inglese',
                'de' => 'Akzeptiert Litauisch UND Englisch',
                'es_MX' => 'Acepta lituano Y inglés',
                'es' => 'Acepta lituano Y inglés',
                'sv' => 'Accepterar litauiska OCH engelska',
                'pl' => 'Akceptuje litewski I angielski',
                'et' => 'Aktsepteerib leedu JA inglise keelt'
            ],
            'accepts_only_lt' => [
                'en' => 'Accepts only Lithuanian',
                'lt' => 'Priima tik lietuvių',
                'it' => 'Accetta solo lituano',
                'de' => 'Akzeptiert nur Litauisch',
                'es_MX' => 'Acepta solo lituano',
                'es' => 'Acepta solo lituano',
                'sv' => 'Accepterar endast litauiska',
                'pl' => 'Akceptuje tylko litewski',
                'et' => 'Aktsepteerib ainult leedu keelt'
            ],
            'accepts_de_en' => [
                'en' => 'Accepts German AND English',
                'lt' => 'Priima vokiečių IR anglų',
                'it' => 'Accetta tedesco E inglese',
                'de' => 'Akzeptiert Deutsch UND Englisch',
                'es_MX' => 'Acepta alemán Y inglés',
                'es' => 'Acepta alemán Y inglés',
                'sv' => 'Accepterar tyska OCH engelska',
                'pl' => 'Akceptuje niemiecki I angielski',
                'et' => 'Aktsepteerib saksa JA inglise keelt'
            ],
            'language_codes' => [
                'en' => 'Language codes',
                'lt' => 'Kalbų kodai',
                'it' => 'Codici lingua',
                'de' => 'Sprachcodes',
                'es_MX' => 'Códigos de idioma',
                'es' => 'Códigos de idioma',
                'sv' => 'Språkkoder',
                'pl' => 'Kody języków',
                'et' => 'Keelekoodid'
            ],
            'spam_score_label' => [
                'en' => 'Spam Score',
                'lt' => 'Šlamšto balas',
                'it' => 'Punteggio spam',
                'de' => 'Spam-Punktzahl',
                'es_MX' => 'Puntuación de spam',
                'es' => 'Puntuación de spam',
                'sv' => 'Skräppostpoäng',
                'pl' => 'Wynik spamu',
                'et' => 'Rämpsposti skoor'
            ],
            'spam_score_description' => [
                'en' => 'Points added when gibberish is detected (default: 85)',
                'lt' => 'Taškai pridedami aptikus nesąmonę (numatytasis: 85)',
                'it' => 'Punti aggiunti quando viene rilevato testo senza senso (predefinito: 85)',
                'de' => 'Punkte hinzugefügt wenn Unsinn erkannt wird (Standard: 85)',
                'es_MX' => 'Puntos agregados cuando se detecta texto sin sentido (predeterminado: 85)',
                'es' => 'Puntos agregados cuando se detecta texto sin sentido (predeterminado: 85)',
                'sv' => 'Poäng som läggs till när nonsens upptäcks (standard: 85)',
                'pl' => 'Punkty dodawane gdy wykryto bełkot (domyślnie: 85)',
                'et' => 'Punktid lisatakse mõttetu teksti tuvastamisel (vaikimisi: 85)'
            ],
            'min_text_length' => [
                'en' => 'Minimum Text Length',
                'lt' => 'Minimalus teksto ilgis',
                'it' => 'Lunghezza minima testo',
                'de' => 'Minimale Textlänge',
                'es_MX' => 'Longitud mínima de texto',
                'es' => 'Longitud mínima de texto',
                'sv' => 'Minimitextlängd',
                'pl' => 'Minimalna długość tekstu',
                'et' => 'Minimaalne teksti pikkus'
            ],
            'min_text_length_description' => [
                'en' => 'Only check text longer than this (to save API calls)',
                'lt' => 'Tikrinti tik ilgesnį tekstą (taupyti API užklausas)',
                'it' => 'Controlla solo testo più lungo di questo (per risparmiare chiamate API)',
                'de' => 'Nur Text länger als dies prüfen (um API-Aufrufe zu sparen)',
                'es_MX' => 'Solo verificar texto más largo que esto (para ahorrar llamadas API)',
                'es' => 'Solo verificar texto más largo que esto (para ahorrar llamadas API)',
                'sv' => 'Kontrollera endast text längre än detta (för att spara API-anrop)',
                'pl' => 'Sprawdzaj tylko tekst dłuższy niż ten (aby oszczędzić wywołania API)',
                'et' => 'Kontrolli ainult pikemat teksti kui see (API päringute säästmiseks)'
            ],
            'ai_cost_notice' => [
                'en' => 'AI is only called when local pattern detection flags suspicious text. Typical cost: less than $0.01 per suspicious submission.',
                'lt' => 'AI kviečiamas tik kai vietinis šablonų aptikimas pažymi įtartiną tekstą. Tipinė kaina: mažiau nei 0,01 $ už įtartiną pateikimą.',
                'it' => 'L\'AI viene chiamata solo quando il rilevamento locale dei pattern segnala testo sospetto. Costo tipico: meno di 0,01 $ per invio sospetto.',
                'de' => 'KI wird nur aufgerufen wenn lokale Mustererkennung verdächtigen Text markiert. Typische Kosten: weniger als 0,01 $ pro verdächtiger Einreichung.',
                'es_MX' => 'La IA solo se llama cuando la detección local de patrones marca texto sospechoso. Costo típico: menos de $0.01 por envío sospechoso.',
                'es' => 'La IA solo se llama cuando la detección local de patrones marca texto sospechoso. Costo típico: menos de 0,01 $ por envío sospechoso.',
                'sv' => 'AI anropas endast när lokal mönsterigenkänning flaggar misstänkt text. Typisk kostnad: mindre än 0,01 $ per misstänkt inskickning.',
                'pl' => 'AI jest wywoływane tylko gdy lokalne wykrywanie wzorców oznacza podejrzany tekst. Typowy koszt: mniej niż 0,01 $ za podejrzane zgłoszenie.',
                'et' => 'Tehisintellekti kutsutakse ainult siis, kui kohalik mustrituvastus märgib kahtlase teksti. Tüüpiline kulu: alla 0,01 $ kahtlase esituse kohta.'
            ],

            // Spam Messages
            'spam_error_messages' => [
                'en' => 'Spam Error Messages',
                'lt' => 'Šlamšto klaidų pranešimai',
                'it' => 'Messaggi errore spam',
                'de' => 'Spam-Fehlermeldungen',
                'es_MX' => 'Mensajes de error de spam',
                'es' => 'Mensajes de error de spam',
                'sv' => 'Skräppostfelmeddelanden',
                'pl' => 'Komunikaty błędów spamu',
                'et' => 'Rämpsposti veateated'
            ],
            'spam_messages_description' => [
                'en' => 'Customize the error message shown to users when their submission is blocked as spam.',
                'lt' => 'Tinkinkite klaidos pranešimą rodomą naudotojams, kai jų pateikimas užblokuojamas kaip šlamštas.',
                'it' => 'Personalizza il messaggio di errore mostrato agli utenti quando il loro invio viene bloccato come spam.',
                'de' => 'Passen Sie die Fehlermeldung an, die Benutzern angezeigt wird, wenn ihre Einreichung als Spam blockiert wird.',
                'es_MX' => 'Personaliza el mensaje de error mostrado a los usuarios cuando su envío se bloquea como spam.',
                'es' => 'Personaliza el mensaje de error mostrado a los usuarios cuando su envío se bloquea como spam.',
                'sv' => 'Anpassa felmeddelandet som visas för användare när deras inskickning blockeras som skräppost.',
                'pl' => 'Dostosuj komunikat błędu wyświetlany użytkownikom gdy ich zgłoszenie jest blokowane jako spam.',
                'et' => 'Kohandage kasutajatele kuvatavat veateadet, kui nende esitus blokeeritakse rämpspostina.'
            ],
            'message_mode' => [
                'en' => 'Message Mode',
                'lt' => 'Pranešimo režimas',
                'it' => 'Modalità messaggio',
                'de' => 'Nachrichtenmodus',
                'es_MX' => 'Modo de mensaje',
                'es' => 'Modo de mensaje',
                'sv' => 'Meddelandeläge',
                'pl' => 'Tryb wiadomości',
                'et' => 'Sõnumi režiim'
            ],
            'mode_auto_detect' => [
                'en' => 'Auto (detect language from WPML/Polylang/domain)',
                'lt' => 'Automatinis (aptikti kalbą iš WPML/Polylang/domeno)',
                'it' => 'Auto (rileva lingua da WPML/Polylang/dominio)',
                'de' => 'Auto (Sprache aus WPML/Polylang/Domain erkennen)',
                'es_MX' => 'Auto (detectar idioma de WPML/Polylang/dominio)',
                'es' => 'Auto (detectar idioma de WPML/Polylang/dominio)',
                'sv' => 'Auto (upptäck språk från WPML/Polylang/domän)',
                'pl' => 'Auto (wykryj język z WPML/Polylang/domeny)',
                'et' => 'Automaatne (tuvasta keel WPML/Polylang/domeenist)'
            ],
            'mode_custom_single' => [
                'en' => 'Custom (single message for all)',
                'lt' => 'Pasirinktinis (vienas pranešimas visiems)',
                'it' => 'Personalizzato (messaggio singolo per tutti)',
                'de' => 'Benutzerdefiniert (eine Nachricht für alle)',
                'es_MX' => 'Personalizado (mensaje único para todos)',
                'es' => 'Personalizado (mensaje único para todos)',
                'sv' => 'Anpassad (ett meddelande för alla)',
                'pl' => 'Niestandardowy (jedna wiadomość dla wszystkich)',
                'et' => 'Kohandatud (üks sõnum kõigile)'
            ],
            'mode_per_domain' => [
                'en' => 'Per Domain (different message per domain)',
                'lt' => 'Pagal domeną (skirtingas pranešimas kiekvienam domenui)',
                'it' => 'Per dominio (messaggio diverso per dominio)',
                'de' => 'Pro Domain (unterschiedliche Nachricht pro Domain)',
                'es_MX' => 'Por dominio (mensaje diferente por dominio)',
                'es' => 'Por dominio (mensaje diferente por dominio)',
                'sv' => 'Per domän (olika meddelande per domän)',
                'pl' => 'Dla domeny (inna wiadomość dla domeny)',
                'et' => 'Domeeni kohta (erinev sõnum domeeni kohta)'
            ],
            'custom_message' => [
                'en' => 'Custom Message',
                'lt' => 'Pasirinktinis pranešimas',
                'it' => 'Messaggio personalizzato',
                'de' => 'Benutzerdefinierte Nachricht',
                'es_MX' => 'Mensaje personalizado',
                'es' => 'Mensaje personalizado',
                'sv' => 'Anpassat meddelande',
                'pl' => 'Niestandardowa wiadomość',
                'et' => 'Kohandatud sõnum'
            ],
            'custom_message_description' => [
                'en' => 'This message will be shown for ALL blocked submissions.',
                'lt' => 'Šis pranešimas bus rodomas VISIEMS užblokuotiems pateikimams.',
                'it' => 'Questo messaggio verrà mostrato per TUTTI gli invii bloccati.',
                'de' => 'Diese Nachricht wird für ALLE blockierten Einreichungen angezeigt.',
                'es_MX' => 'Este mensaje se mostrará para TODOS los envíos bloqueados.',
                'es' => 'Este mensaje se mostrará para TODOS los envíos bloqueados.',
                'sv' => 'Detta meddelande visas för ALLA blockerade inskickningar.',
                'pl' => 'Ta wiadomość będzie wyświetlana dla WSZYSTKICH zablokowanych zgłoszeń.',
                'et' => 'See sõnum kuvatakse KÕIGI blokeeritud esituste puhul.'
            ],
            'messages_per_domain' => [
                'en' => 'Messages Per Domain',
                'lt' => 'Pranešimai pagal domeną',
                'it' => 'Messaggi per dominio',
                'de' => 'Nachrichten pro Domain',
                'es_MX' => 'Mensajes por dominio',
                'es' => 'Mensajes por dominio',
                'sv' => 'Meddelanden per domän',
                'pl' => 'Wiadomości dla domeny',
                'et' => 'Sõnumid domeeni kohta'
            ],
            'messages_per_domain_description' => [
                'en' => 'Set different error messages for each domain.',
                'lt' => 'Nustatykite skirtingus klaidų pranešimus kiekvienam domenui.',
                'it' => 'Imposta messaggi di errore diversi per ogni dominio.',
                'de' => 'Legen Sie unterschiedliche Fehlermeldungen für jede Domain fest.',
                'es_MX' => 'Establece diferentes mensajes de error para cada dominio.',
                'es' => 'Establece diferentes mensajes de error para cada dominio.',
                'sv' => 'Ställ in olika felmeddelanden för varje domän.',
                'pl' => 'Ustaw różne komunikaty błędów dla każdej domeny.',
                'et' => 'Määrake iga domeeni jaoks erinevad veateated.'
            ],
            'default_message_fallback' => [
                'en' => 'Default Message (fallback)',
                'lt' => 'Numatytasis pranešimas (atsarginis)',
                'it' => 'Messaggio predefinito (fallback)',
                'de' => 'Standardnachricht (Fallback)',
                'es_MX' => 'Mensaje predeterminado (respaldo)',
                'es' => 'Mensaje predeterminado (respaldo)',
                'sv' => 'Standardmeddelande (reserv)',
                'pl' => 'Domyślna wiadomość (zapasowa)',
                'et' => 'Vaikesõnum (varukeel)'
            ],
            'default_message_description' => [
                'en' => 'Shown when the domain doesn\'t match any of the above. If empty, falls back to auto-detected language.',
                'lt' => 'Rodomas kai domenas neatitinka jokio iš aukščiau nurodytų. Jei tuščias, grįžtama į automatiškai aptiktą kalbą.',
                'it' => 'Mostrato quando il dominio non corrisponde a nessuno dei precedenti. Se vuoto, ricade sulla lingua rilevata automaticamente.',
                'de' => 'Wird angezeigt wenn die Domain keiner der obigen entspricht. Wenn leer, wird auf automatisch erkannte Sprache zurückgegriffen.',
                'es_MX' => 'Se muestra cuando el dominio no coincide con ninguno de los anteriores. Si está vacío, recurre al idioma detectado automáticamente.',
                'es' => 'Se muestra cuando el dominio no coincide con ninguno de los anteriores. Si está vacío, recurre al idioma detectado automáticamente.',
                'sv' => 'Visas när domänen inte matchar någon av ovanstående. Om tom, återgår till automatiskt upptäckt språk.',
                'pl' => 'Wyświetlany gdy domena nie pasuje do żadnej z powyższych. Jeśli pusty, wraca do automatycznie wykrytego języka.',
                'et' => 'Kuvatakse kui domeen ei vasta ühelegi ülaltoodule. Kui tühi, kasutatakse automaatselt tuvastatud keelt.'
            ],
            'builtin_translations' => [
                'en' => 'Built-in translations',
                'lt' => 'Įdiegti vertimai',
                'it' => 'Traduzioni integrate',
                'de' => 'Integrierte Übersetzungen',
                'es_MX' => 'Traducciones integradas',
                'es' => 'Traducciones integradas',
                'sv' => 'Inbyggda översättningar',
                'pl' => 'Wbudowane tłumaczenia',
                'et' => 'Sisseehitatud tõlked'
            ],
            'builtin_languages_list' => [
                'en' => 'English, Lithuanian, German, French, Spanish, Italian, Polish, Russian, Dutch, Portuguese',
                'lt' => 'Anglų, lietuvių, vokiečių, prancūzų, ispanų, italų, lenkų, rusų, olandų, portugalų',
                'it' => 'Inglese, lituano, tedesco, francese, spagnolo, italiano, polacco, russo, olandese, portoghese',
                'de' => 'Englisch, Litauisch, Deutsch, Französisch, Spanisch, Italienisch, Polnisch, Russisch, Niederländisch, Portugiesisch',
                'es_MX' => 'Inglés, lituano, alemán, francés, español, italiano, polaco, ruso, holandés, portugués',
                'es' => 'Inglés, lituano, alemán, francés, español, italiano, polaco, ruso, holandés, portugués',
                'sv' => 'Engelska, litauiska, tyska, franska, spanska, italienska, polska, ryska, holländska, portugisiska',
                'pl' => 'Angielski, litewski, niemiecki, francuski, hiszpański, włoski, polski, rosyjski, holenderski, portugalski',
                'et' => 'Inglise, leedu, saksa, prantsuse, hispaania, itaalia, poola, vene, hollandi, portugali'
            ],
            'auto_language_detection_note' => [
                'en' => 'Language is automatically detected from WPML, Polylang, or your domain language settings above.',
                'lt' => 'Kalba automatiškai aptinkama iš WPML, Polylang arba jūsų domeno kalbos nustatymų aukščiau.',
                'it' => 'La lingua viene rilevata automaticamente da WPML, Polylang o dalle impostazioni lingua del dominio sopra.',
                'de' => 'Sprache wird automatisch aus WPML, Polylang oder Ihren Domain-Spracheinstellungen oben erkannt.',
                'es_MX' => 'El idioma se detecta automáticamente desde WPML, Polylang o la configuración de idioma del dominio de arriba.',
                'es' => 'El idioma se detecta automáticamente desde WPML, Polylang o la configuración de idioma del dominio de arriba.',
                'sv' => 'Språket upptäcks automatiskt från WPML, Polylang eller dina domänspråkinställningar ovan.',
                'pl' => 'Język jest automatycznie wykrywany z WPML, Polylang lub ustawień języka domeny powyżej.',
                'et' => 'Keel tuvastatakse automaatselt WPML-ist, Polylangist või teie domeeni keeleseadetest ülal.'
            ],

            // Advanced
            'advanced' => [
                'en' => 'Advanced',
                'lt' => 'Išplėstiniai',
                'it' => 'Avanzato',
                'de' => 'Erweitert',
                'es_MX' => 'Avanzado',
                'es' => 'Avanzado',
                'sv' => 'Avancerat',
                'pl' => 'Zaawansowane',
                'et' => 'Täpsemad'
            ],
            'delete_data_uninstall' => [
                'en' => 'Delete Data on Uninstall',
                'lt' => 'Ištrinti duomenis pašalinant',
                'it' => 'Elimina dati alla disinstallazione',
                'de' => 'Daten bei Deinstallation löschen',
                'es_MX' => 'Eliminar datos al desinstalar',
                'es' => 'Eliminar datos al desinstalar',
                'sv' => 'Radera data vid avinstallation',
                'pl' => 'Usuń dane przy odinstalowaniu',
                'et' => 'Kustuta andmed desinstallimisel'
            ],
            'save_settings' => [
                'en' => 'Save Settings',
                'lt' => 'Išsaugoti nustatymus',
                'it' => 'Salva impostazioni',
                'de' => 'Einstellungen speichern',
                'es_MX' => 'Guardar configuración',
                'es' => 'Guardar configuración',
                'sv' => 'Spara inställningar',
                'pl' => 'Zapisz ustawienia',
                'et' => 'Salvesta seaded'
            ],
            'footer_text' => [
                'en' => 'Honeypot Guard - Open Source Anti-Spam',
                'lt' => 'Honeypot Guard - Atviro kodo anti-spam',
                'it' => 'Honeypot Guard - Anti-Spam Open Source',
                'de' => 'Honeypot Guard - Open Source Anti-Spam',
                'es_MX' => 'Honeypot Guard - Anti-Spam de código abierto',
                'es' => 'Honeypot Guard - Anti-Spam de código abierto',
                'sv' => 'Honeypot Guard - Öppen källkod anti-spam',
                'pl' => 'Honeypot Guard - Open Source Anti-Spam',
                'et' => 'Honeypot Guard - Avatud lähtekoodiga rämpsposti tõrje'
            ],
            'report_issues' => [
                'en' => 'Report Issues',
                'lt' => 'Pranešti apie problemas',
                'it' => 'Segnala problemi',
                'de' => 'Probleme melden',
                'es_MX' => 'Reportar problemas',
                'es' => 'Reportar problemas',
                'sv' => 'Rapportera problem',
                'pl' => 'Zgłoś problemy',
                'et' => 'Teata probleemidest'
            ],

            // =====================================================
            // HELP TOOLTIPS FOR SETTINGS
            // =====================================================
            'help_honeypot' => [
                'en' => 'Invisible trap fields that catch bots. Humans never see them, but bots fill them automatically.',
                'lt' => 'Nematomi spąstų laukai, kurie pagauna botus. Žmonės jų nemato, bet botai juos automatiškai užpildo.',
                'it' => 'Campi trappola invisibili che catturano i bot. Gli umani non li vedono, ma i bot li compilano automaticamente.',
                'de' => 'Unsichtbare Fallen-Felder, die Bots fangen. Menschen sehen sie nie, aber Bots füllen sie automatisch aus.',
                'es_MX' => 'Campos trampa invisibles que atrapan bots. Los humanos nunca los ven, pero los bots los llenan automáticamente.',
                'es' => 'Campos trampa invisibles que atrapan bots. Los humanos nunca los ven, pero los bots los llenan automáticamente.',
                'sv' => 'Osynliga fällfält som fångar botar. Människor ser dem aldrig, men botar fyller i dem automatiskt.',
                'pl' => 'Niewidoczne pola-pułapki, które łapią boty. Ludzie ich nie widzą, ale boty wypełniają je automatycznie.',
                'et' => 'Nähtamatud lõksväljad, mis püüavad roboteid. Inimesed neid ei näe, kuid robotid täidavad need automaatselt.'
            ],
            'help_registration' => [
                'en' => 'Protect WordPress and WooCommerce registration forms from spam bots.',
                'lt' => 'Apsaugokite WordPress ir WooCommerce registracijos formas nuo šlamšto botų.',
                'it' => 'Proteggi i moduli di registrazione WordPress e WooCommerce dai bot spam.',
                'de' => 'Schützen Sie WordPress- und WooCommerce-Registrierungsformulare vor Spam-Bots.',
                'es_MX' => 'Protege los formularios de registro de WordPress y WooCommerce de bots de spam.',
                'es' => 'Protege los formularios de registro de WordPress y WooCommerce de bots de spam.',
                'sv' => 'Skydda WordPress- och WooCommerce-registreringsformulär från skräppostbotar.',
                'pl' => 'Chroń formularze rejestracji WordPress i WooCommerce przed botami spamowymi.',
                'et' => 'Kaitske WordPressi ja WooCommerce\'i registreerimisvorme rämpsposti robotite eest.'
            ],
            'help_timestamp' => [
                'en' => 'Block submissions that are too fast (bots) or too slow (expired sessions).',
                'lt' => 'Blokuoti pateikimus, kurie yra per greiti (botai) arba per lėti (pasibaigusios sesijos).',
                'it' => 'Blocca gli invii troppo veloci (bot) o troppo lenti (sessioni scadute).',
                'de' => 'Blockieren Sie Einreichungen, die zu schnell (Bots) oder zu langsam (abgelaufene Sitzungen) sind.',
                'es_MX' => 'Bloquea envíos que son demasiado rápidos (bots) o demasiado lentos (sesiones expiradas).',
                'es' => 'Bloquea envíos que son demasiado rápidos (bots) o demasiado lentos (sesiones expiradas).',
                'sv' => 'Blockera inskickningar som är för snabba (botar) eller för långsamma (utgångna sessioner).',
                'pl' => 'Blokuj zgłoszenia, które są zbyt szybkie (boty) lub zbyt wolne (wygasłe sesje).',
                'et' => 'Blokeeri liiga kiired (robotid) või liiga aeglased (aegunud seansid) esitused.'
            ],
            'help_rate_limiting' => [
                'en' => 'Limit how many submissions one IP address can make in a time period.',
                'lt' => 'Riboti, kiek pateikimų vienas IP adresas gali atlikti per tam tikrą laikotarpį.',
                'it' => 'Limita quanti invii un indirizzo IP può fare in un periodo di tempo.',
                'de' => 'Begrenzen Sie, wie viele Einreichungen eine IP-Adresse in einem Zeitraum machen kann.',
                'es_MX' => 'Limita cuántos envíos puede hacer una dirección IP en un período de tiempo.',
                'es' => 'Limita cuántos envíos puede hacer una dirección IP en un período de tiempo.',
                'sv' => 'Begränsa hur många inskickningar en IP-adress kan göra under en tidsperiod.',
                'pl' => 'Ogranicz liczbę zgłoszeń, które jeden adres IP może wysłać w określonym czasie.',
                'et' => 'Piirake, mitu esitust üks IP-aadress võib teatud ajavahemikus teha.'
            ],
            'help_character_filtering' => [
                'en' => 'Block submissions containing specific character sets like Cyrillic, Chinese, or South Asian scripts.',
                'lt' => 'Blokuoti pateikimus, kuriuose yra tam tikri simbolių rinkiniai, pvz., kirilica, kinų ar Pietų Azijos raštai.',
                'it' => 'Blocca gli invii contenenti set di caratteri specifici come cirillico, cinese o scritture sud asiatiche.',
                'de' => 'Blockieren Sie Einreichungen mit bestimmten Zeichensätzen wie Kyrillisch, Chinesisch oder südasiatischen Schriften.',
                'es_MX' => 'Bloquea envíos que contienen conjuntos de caracteres específicos como cirílico, chino o escrituras del sur de Asia.',
                'es' => 'Bloquea envíos que contienen conjuntos de caracteres específicos como cirílico, chino o escrituras del sur de Asia.',
                'sv' => 'Blockera inskickningar som innehåller specifika teckenuppsättningar som kyrilliska, kinesiska eller sydasiatiska skriftspråk.',
                'pl' => 'Blokuj zgłoszenia zawierające określone zestawy znaków, takie jak cyrylica, chińskie lub południowoazjatyckie pisma.',
                'et' => 'Blokeeri esitused, mis sisaldavad teatud tähemärkide komplekte nagu kirillitsa, hiina või Lõuna-Aasia kirjad.'
            ],
            'help_email_blacklist' => [
                'en' => 'Block specific email addresses. Supports wildcards like *@spam.com',
                'lt' => 'Blokuoti konkrečius el. pašto adresus. Palaiko pakaitos simbolius, pvz., *@spam.com',
                'it' => 'Blocca indirizzi email specifici. Supporta caratteri jolly come *@spam.com',
                'de' => 'Blockieren Sie bestimmte E-Mail-Adressen. Unterstützt Platzhalter wie *@spam.com',
                'es_MX' => 'Bloquea direcciones de correo específicas. Soporta comodines como *@spam.com',
                'es' => 'Bloquea direcciones de correo específicas. Soporta comodines como *@spam.com',
                'sv' => 'Blockera specifika e-postadresser. Stöder jokertecken som *@spam.com',
                'pl' => 'Blokuj określone adresy e-mail. Obsługuje znaki wieloznaczne, np. *@spam.com',
                'et' => 'Blokeeri konkreetsed e-posti aadressid. Toetab metamärke nagu *@spam.com'
            ],
            'help_domain_blacklist' => [
                'en' => 'Block all emails from specific domains. Use *.domain.com for subdomains.',
                'lt' => 'Blokuoti visus el. laiškus iš konkrečių domenų. Naudokite *.domain.com subdomenams.',
                'it' => 'Blocca tutte le email da domini specifici. Usa *.domain.com per i sottodomini.',
                'de' => 'Blockieren Sie alle E-Mails von bestimmten Domains. Verwenden Sie *.domain.com für Subdomains.',
                'es_MX' => 'Bloquea todos los correos de dominios específicos. Usa *.domain.com para subdominios.',
                'es' => 'Bloquea todos los correos de dominios específicos. Usa *.domain.com para subdominios.',
                'sv' => 'Blockera alla e-postmeddelanden från specifika domäner. Använd *.domain.com för subdomäner.',
                'pl' => 'Blokuj wszystkie e-maile z określonych domen. Użyj *.domain.com dla subdomen.',
                'et' => 'Blokeeri kõik e-kirjad konkreetsetelt domeenidelt. Kasuta *.domain.com alamdomeenide jaoks.'
            ],
            'help_ip_blacklist' => [
                'en' => 'Block specific IP addresses. Supports CIDR notation like 192.168.1.0/24',
                'lt' => 'Blokuoti konkrečius IP adresus. Palaiko CIDR žymėjimą, pvz., 192.168.1.0/24',
                'it' => 'Blocca indirizzi IP specifici. Supporta la notazione CIDR come 192.168.1.0/24',
                'de' => 'Blockieren Sie bestimmte IP-Adressen. Unterstützt CIDR-Notation wie 192.168.1.0/24',
                'es_MX' => 'Bloquea direcciones IP específicas. Soporta notación CIDR como 192.168.1.0/24',
                'es' => 'Bloquea direcciones IP específicas. Soporta notación CIDR como 192.168.1.0/24',
                'sv' => 'Blockera specifika IP-adresser. Stöder CIDR-notation som 192.168.1.0/24',
                'pl' => 'Blokuj określone adresy IP. Obsługuje notację CIDR, np. 192.168.1.0/24',
                'et' => 'Blokeeri konkreetsed IP-aadressid. Toetab CIDR-märkimist nagu 192.168.1.0/24'
            ],
            'help_keywords' => [
                'en' => 'Block submissions containing specific words or phrases. One keyword per line.',
                'lt' => 'Blokuoti pateikimus, kuriuose yra tam tikri žodžiai ar frazės. Po vieną raktažodį eilutėje.',
                'it' => 'Blocca gli invii contenenti parole o frasi specifiche. Una parola chiave per riga.',
                'de' => 'Blockieren Sie Einreichungen mit bestimmten Wörtern oder Phrasen. Ein Schlüsselwort pro Zeile.',
                'es_MX' => 'Bloquea envíos que contienen palabras o frases específicas. Una palabra clave por línea.',
                'es' => 'Bloquea envíos que contienen palabras o frases específicas. Una palabra clave por línea.',
                'sv' => 'Blockera inskickningar som innehåller specifika ord eller fraser. Ett nyckelord per rad.',
                'pl' => 'Blokuj zgłoszenia zawierające określone słowa lub frazy. Jedno słowo kluczowe na linię.',
                'et' => 'Blokeeri esitused, mis sisaldavad konkreetseid sõnu või fraase. Üks märksõna rea kohta.'
            ],
            'help_smart_detection' => [
                'en' => 'Advanced spam detection using pattern matching, link counting, and spam score calculation.',
                'lt' => 'Pažangi šlamšto aptikimo sistema, naudojanti šablonų atitikimą, nuorodų skaičiavimą ir šlamšto balo skaičiavimą.',
                'it' => 'Rilevamento avanzato dello spam utilizzando pattern matching, conteggio link e calcolo del punteggio spam.',
                'de' => 'Erweiterte Spam-Erkennung mit Mustererkennung, Link-Zählung und Spam-Score-Berechnung.',
                'es_MX' => 'Detección avanzada de spam usando coincidencia de patrones, conteo de enlaces y cálculo de puntuación de spam.',
                'es' => 'Detección avanzada de spam usando coincidencia de patrones, conteo de enlaces y cálculo de puntuación de spam.',
                'sv' => 'Avancerad skräppostdetektering med mönstermatchning, länkräkning och beräkning av skräppostpoäng.',
                'pl' => 'Zaawansowane wykrywanie spamu przy użyciu dopasowywania wzorców, liczenia linków i obliczania wyniku spamu.',
                'et' => 'Täiustatud rämpsposti tuvastamine mustrite sobitamise, linkide loendamise ja rämpsposti skoori arvutamise abil.'
            ],
            'help_security' => [
                'en' => 'Additional security settings like referer checking and user whitelisting.',
                'lt' => 'Papildomi saugumo nustatymai, pvz., nukreipimo tikrinimas ir vartotojų baltasis sąrašas.',
                'it' => 'Impostazioni di sicurezza aggiuntive come controllo referrer e whitelist utenti.',
                'de' => 'Zusätzliche Sicherheitseinstellungen wie Referrer-Prüfung und Benutzer-Whitelist.',
                'es_MX' => 'Configuraciones de seguridad adicionales como verificación de referrer y lista blanca de usuarios.',
                'es' => 'Configuraciones de seguridad adicionales como verificación de referrer y lista blanca de usuarios.',
                'sv' => 'Ytterligare säkerhetsinställningar som refererekontroll och användarvitlistning.',
                'pl' => 'Dodatkowe ustawienia bezpieczeństwa, takie jak sprawdzanie referrera i biała lista użytkowników.',
                'et' => 'Täiendavad turvaseaded nagu viitaja kontrollimine ja kasutajate valge nimekiri.'
            ],
            'help_logging' => [
                'en' => 'Configure how long to keep spam logs and whether to log clean submissions.',
                'lt' => 'Nustatykite, kiek laiko saugoti šlamšto žurnalus ir ar registruoti švarius pateikimus.',
                'it' => 'Configura per quanto tempo conservare i log spam e se registrare gli invii puliti.',
                'de' => 'Konfigurieren Sie, wie lange Spam-Protokolle aufbewahrt werden und ob saubere Einreichungen protokolliert werden.',
                'es_MX' => 'Configura cuánto tiempo guardar los registros de spam y si registrar envíos limpios.',
                'es' => 'Configura cuánto tiempo guardar los registros de spam y si registrar envíos limpios.',
                'sv' => 'Konfigurera hur länge skräppostloggar ska sparas och om rena inskickningar ska loggas.',
                'pl' => 'Skonfiguruj, jak długo przechowywać logi spamu i czy rejestrować czyste zgłoszenia.',
                'et' => 'Seadistage, kui kaua rämpsposti logisid säilitada ja kas logida puhtaid esitusi.'
            ],
            'help_escalation' => [
                'en' => 'Get notified when multiple spam attempts are detected from the same source.',
                'lt' => 'Gaukite pranešimus, kai aptinkama keletas šlamšto bandymų iš to paties šaltinio.',
                'it' => 'Ricevi notifiche quando vengono rilevati più tentativi di spam dalla stessa fonte.',
                'de' => 'Werden Sie benachrichtigt, wenn mehrere Spam-Versuche von derselben Quelle erkannt werden.',
                'es_MX' => 'Recibe notificaciones cuando se detectan múltiples intentos de spam desde la misma fuente.',
                'es' => 'Recibe notificaciones cuando se detectan múltiples intentos de spam desde la misma fuente.',
                'sv' => 'Få meddelanden när flera skräppostförsök upptäcks från samma källa.',
                'pl' => 'Otrzymuj powiadomienia, gdy wykryto wiele prób spamu z tego samego źródła.',
                'et' => 'Saage teavitusi, kui samast allikast tuvastatakse mitu rämpsposti katset.'
            ],
            'help_ai_gibberish' => [
                'en' => 'Use AI to detect nonsense text and gibberish in the wrong language. Requires API key.',
                'lt' => 'Naudokite AI aptikti beprasmį tekstą ir nesąmones netinkama kalba. Reikalingas API raktas.',
                'it' => 'Usa l\'AI per rilevare testo senza senso e parole incomprensibili nella lingua sbagliata. Richiede chiave API.',
                'de' => 'Verwenden Sie KI, um Unsinn-Text und Kauderwelsch in der falschen Sprache zu erkennen. API-Schlüssel erforderlich.',
                'es_MX' => 'Usa IA para detectar texto sin sentido y galimatías en el idioma incorrecto. Requiere clave API.',
                'es' => 'Usa IA para detectar texto sin sentido y galimatías en el idioma incorrecto. Requiere clave API.',
                'sv' => 'Använd AI för att upptäcka meningslös text och struntprat på fel språk. Kräver API-nyckel.',
                'pl' => 'Użyj AI do wykrywania bezsensownego tekstu i bełkotu w niewłaściwym języku. Wymaga klucza API.',
                'et' => 'Kasutage tehisintellekti, et tuvastada mõttetu teksti ja jama vales keeles. Vajab API-võtit.'
            ],
            'help_spam_messages' => [
                'en' => 'Customize the error message shown to users when their submission is blocked.',
                'lt' => 'Pritaikykite klaidos pranešimą, rodomą vartotojams, kai jų pateikimas užblokuojamas.',
                'it' => 'Personalizza il messaggio di errore mostrato agli utenti quando il loro invio viene bloccato.',
                'de' => 'Passen Sie die Fehlermeldung an, die Benutzern angezeigt wird, wenn ihre Einreichung blockiert wird.',
                'es_MX' => 'Personaliza el mensaje de error que se muestra a los usuarios cuando su envío es bloqueado.',
                'es' => 'Personaliza el mensaje de error que se muestra a los usuarios cuando su envío es bloqueado.',
                'sv' => 'Anpassa felmeddelandet som visas för användare när deras inskickning blockeras.',
                'pl' => 'Dostosuj komunikat o błędzie wyświetlany użytkownikom, gdy ich zgłoszenie zostanie zablokowane.',
                'et' => 'Kohandage veateadet, mis kuvatakse kasutajatele, kui nende esitus blokeeritakse.'
            ],
            'help_advanced' => [
                'en' => 'Advanced options like deleting all plugin data when uninstalling.',
                'lt' => 'Išplėstinės parinktys, pvz., visų įskiepio duomenų ištrynimas pašalinant.',
                'it' => 'Opzioni avanzate come l\'eliminazione di tutti i dati del plugin durante la disinstallazione.',
                'de' => 'Erweiterte Optionen wie das Löschen aller Plugin-Daten bei der Deinstallation.',
                'es_MX' => 'Opciones avanzadas como eliminar todos los datos del plugin al desinstalar.',
                'es' => 'Opciones avanzadas como eliminar todos los datos del plugin al desinstalar.',
                'sv' => 'Avancerade alternativ som att radera all plugin-data vid avinstallation.',
                'pl' => 'Zaawansowane opcje, takie jak usuwanie wszystkich danych wtyczki podczas odinstalowywania.',
                'et' => 'Täpsemad valikud nagu kõigi pistikprogrammi andmete kustutamine desinstallimisel.'
            ],

            // =====================================================
            // BLACKLIST PAGE
            // =====================================================
            'blacklist_management' => [
                'en' => 'Blacklist Management',
                'lt' => 'Juodojo sąrašo valdymas',
                'it' => 'Gestione lista nera',
                'de' => 'Sperrlisten-Verwaltung',
                'es_MX' => 'Gestión de lista negra',
                'es' => 'Gestión de lista negra',
                'sv' => 'Svartlistehantering',
                'pl' => 'Zarządzanie czarną listą',
                'et' => 'Musta nimekirja haldamine'
            ],
            'blacklist_subtitle' => [
                'en' => 'Manage blocked emails, domains, IPs, and keywords',
                'lt' => 'Valdykite užblokuotus el. paštus, domenus, IP ir raktinius žodžius',
                'it' => 'Gestisci email, domini, IP e parole chiave bloccati',
                'de' => 'Verwalten Sie blockierte E-Mails, Domains, IPs und Schlüsselwörter',
                'es_MX' => 'Administra correos, dominios, IPs y palabras clave bloqueados',
                'es' => 'Administra correos, dominios, IPs y palabras clave bloqueados',
                'sv' => 'Hantera blockerade e-postadresser, domäner, IP-adresser och nyckelord',
                'pl' => 'Zarządzaj zablokowanymi e-mailami, domenami, adresami IP i słowami kluczowymi',
                'et' => 'Halda blokeeritud e-kirju, domeene, IP-aadresse ja märksõnu'
            ],
            'email_type' => [
                'en' => 'Email',
                'lt' => 'El. paštas',
                'it' => 'Email',
                'de' => 'E-Mail',
                'es_MX' => 'Correo',
                'es' => 'Correo',
                'sv' => 'E-post',
                'pl' => 'E-mail',
                'et' => 'E-post'
            ],
            'domain_type' => [
                'en' => 'Domain',
                'lt' => 'Domenas',
                'it' => 'Dominio',
                'de' => 'Domain',
                'es_MX' => 'Dominio',
                'es' => 'Dominio',
                'sv' => 'Domän',
                'pl' => 'Domena',
                'et' => 'Domeen'
            ],
            'ip_address_type' => [
                'en' => 'IP Address',
                'lt' => 'IP adresas',
                'it' => 'Indirizzo IP',
                'de' => 'IP-Adresse',
                'es_MX' => 'Dirección IP',
                'es' => 'Dirección IP',
                'sv' => 'IP-adress',
                'pl' => 'Adres IP',
                'et' => 'IP-aadress'
            ],
            'keyword_type' => [
                'en' => 'Keyword',
                'lt' => 'Raktažodis',
                'it' => 'Parola chiave',
                'de' => 'Schlüsselwort',
                'es_MX' => 'Palabra clave',
                'es' => 'Palabra clave',
                'sv' => 'Nyckelord',
                'pl' => 'Słowo kluczowe',
                'et' => 'Märksõna'
            ],
            'value_to_block' => [
                'en' => 'Value to block...',
                'lt' => 'Reikšmė blokuoti...',
                'it' => 'Valore da bloccare...',
                'de' => 'Wert zum Blockieren...',
                'es_MX' => 'Valor a bloquear...',
                'es' => 'Valor a bloquear...',
                'sv' => 'Värde att blockera...',
                'pl' => 'Wartość do zablokowania...',
                'et' => 'Blokeeritav väärtus...'
            ],
            'reason_optional' => [
                'en' => 'Reason (optional)',
                'lt' => 'Priežastis (neprivaloma)',
                'it' => 'Motivo (opzionale)',
                'de' => 'Grund (optional)',
                'es_MX' => 'Razón (opcional)',
                'es' => 'Razón (opcional)',
                'sv' => 'Anledning (valfritt)',
                'pl' => 'Powód (opcjonalnie)',
                'et' => 'Põhjus (valikuline)'
            ],
            'add_to_blacklist' => [
                'en' => 'Add to Blacklist',
                'lt' => 'Pridėti į juodąjį sąrašą',
                'it' => 'Aggiungi alla lista nera',
                'de' => 'Zur Sperrliste hinzufügen',
                'es_MX' => 'Agregar a lista negra',
                'es' => 'Agregar a lista negra',
                'sv' => 'Lägg till i svartlistan',
                'pl' => 'Dodaj do czarnej listy',
                'et' => 'Lisa musta nimekirja'
            ],
            'active_blacklist_entries' => [
                'en' => 'Active Blacklist Entries',
                'lt' => 'Aktyvūs juodojo sąrašo įrašai',
                'it' => 'Voci attive nella lista nera',
                'de' => 'Aktive Sperrlisteneinträge',
                'es_MX' => 'Entradas activas de lista negra',
                'es' => 'Entradas activas de lista negra',
                'sv' => 'Aktiva svartlisteposter',
                'pl' => 'Aktywne wpisy czarnej listy',
                'et' => 'Aktiivsed musta nimekirja kirjed'
            ],
            'entries' => [
                'en' => 'entries',
                'lt' => 'įrašai',
                'it' => 'voci',
                'de' => 'Einträge',
                'es_MX' => 'entradas',
                'es' => 'entradas',
                'sv' => 'poster',
                'pl' => 'wpisy',
                'et' => 'kirjet'
            ],
            'no_blacklist_entries' => [
                'en' => 'No blacklist entries yet. Add entries using the form above or from the spam logs.',
                'lt' => 'Juodajame sąraše dar nėra įrašų. Pridėkite įrašus naudodami formą aukščiau arba iš šlamšto žurnalų.',
                'it' => 'Nessuna voce nella lista nera. Aggiungi voci usando il modulo sopra o dai log spam.',
                'de' => 'Noch keine Sperrlisteneinträge. Fügen Sie Einträge über das obige Formular oder aus den Spam-Protokollen hinzu.',
                'es_MX' => 'Aún no hay entradas en la lista negra. Agrega entradas usando el formulario de arriba o desde los registros de spam.',
                'es' => 'Aún no hay entradas en la lista negra. Agrega entradas usando el formulario de arriba o desde los registros de spam.',
                'sv' => 'Inga svartlisteposter ännu. Lägg till poster med formuläret ovan eller från skräppostloggarna.',
                'pl' => 'Brak wpisów na czarnej liście. Dodaj wpisy używając formularza powyżej lub z logów spamu.',
                'et' => 'Mustas nimekirjas pole veel kirjeid. Lisage kirjeid ülaltoodud vormi kaudu või rämpspostilogidest.'
            ],
            'type' => [
                'en' => 'Type',
                'lt' => 'Tipas',
                'it' => 'Tipo',
                'de' => 'Typ',
                'es_MX' => 'Tipo',
                'es' => 'Tipo',
                'sv' => 'Typ',
                'pl' => 'Typ',
                'et' => 'Tüüp'
            ],
            'value' => [
                'en' => 'Value',
                'lt' => 'Reikšmė',
                'it' => 'Valore',
                'de' => 'Wert',
                'es_MX' => 'Valor',
                'es' => 'Valor',
                'sv' => 'Värde',
                'pl' => 'Wartość',
                'et' => 'Väärtus'
            ],
            'hits' => [
                'en' => 'Hits',
                'lt' => 'Pataikymai',
                'it' => 'Colpi',
                'de' => 'Treffer',
                'es_MX' => 'Coincidencias',
                'es' => 'Coincidencias',
                'sv' => 'Träffar',
                'pl' => 'Trafienia',
                'et' => 'Tabamused'
            ],
            'added' => [
                'en' => 'Added',
                'lt' => 'Pridėta',
                'it' => 'Aggiunto',
                'de' => 'Hinzugefügt',
                'es_MX' => 'Agregado',
                'es' => 'Agregado',
                'sv' => 'Tillagd',
                'pl' => 'Dodano',
                'et' => 'Lisatud'
            ],
            'ago' => [
                'en' => 'ago',
                'lt' => 'prieš',
                'it' => 'fa',
                'de' => 'vor',
                'es_MX' => 'hace',
                'es' => 'hace',
                'sv' => 'sedan',
                'pl' => 'temu',
                'et' => 'tagasi'
            ],
            'remove' => [
                'en' => 'Remove',
                'lt' => 'Pašalinti',
                'it' => 'Rimuovi',
                'de' => 'Entfernen',
                'es_MX' => 'Eliminar',
                'es' => 'Eliminar',
                'sv' => 'Ta bort',
                'pl' => 'Usuń',
                'et' => 'Eemalda'
            ],
            'quick_tips' => [
                'en' => 'Quick Tips',
                'lt' => 'Greiti patarimai',
                'it' => 'Suggerimenti rapidi',
                'de' => 'Schnelle Tipps',
                'es_MX' => 'Consejos rápidos',
                'es' => 'Consejos rápidos',
                'sv' => 'Snabbtips',
                'pl' => 'Szybkie wskazówki',
                'et' => 'Kiired näpunäited'
            ],
            'tip_email' => [
                'en' => 'Block specific addresses or use wildcards like *@spammer.com',
                'lt' => 'Blokuokite konkrečius adresus arba naudokite pakaitos simbolius, pvz., *@spammer.com',
                'it' => 'Blocca indirizzi specifici o usa caratteri jolly come *@spammer.com',
                'de' => 'Blockieren Sie bestimmte Adressen oder verwenden Sie Platzhalter wie *@spammer.com',
                'es_MX' => 'Bloquea direcciones específicas o usa comodines como *@spammer.com',
                'es' => 'Bloquea direcciones específicas o usa comodines como *@spammer.com',
                'sv' => 'Blockera specifika adresser eller använd jokertecken som *@spammer.com',
                'pl' => 'Zablokuj konkretne adresy lub użyj symboli wieloznacznych jak *@spammer.com',
                'et' => 'Blokeeri konkreetsed aadressid või kasuta metamärke nagu *@spammer.com'
            ],
            'tip_domain' => [
                'en' => 'Blocks emails from and links to this domain. Use *.domain.com for subdomains',
                'lt' => 'Blokuoja el. laiškus iš ir nuorodas į šį domeną. Naudokite *.domain.com subdomenams',
                'it' => 'Blocca email da e link a questo dominio. Usa *.domain.com per i sottodomini',
                'de' => 'Blockiert E-Mails von und Links zu dieser Domain. Verwenden Sie *.domain.com für Subdomains',
                'es_MX' => 'Bloquea correos desde y enlaces a este dominio. Usa *.domain.com para subdominios',
                'es' => 'Bloquea correos desde y enlaces a este dominio. Usa *.domain.com para subdominios',
                'sv' => 'Blockerar e-post från och länkar till denna domän. Använd *.domain.com för underdomäner',
                'pl' => 'Blokuje e-maile z i linki do tej domeny. Użyj *.domain.com dla subdomen',
                'et' => 'Blokeerib e-kirjad sellelt domeenilt ja lingid sellele. Kasuta *.domain.com alamdomeenide jaoks'
            ],
            'tip_ip' => [
                'en' => 'Block single IPs or ranges using CIDR notation (192.168.1.0/24)',
                'lt' => 'Blokuokite pavienius IP arba diapazonus naudodami CIDR notaciją (192.168.1.0/24)',
                'it' => 'Blocca singoli IP o intervalli usando la notazione CIDR (192.168.1.0/24)',
                'de' => 'Blockieren Sie einzelne IPs oder Bereiche mit CIDR-Notation (192.168.1.0/24)',
                'es_MX' => 'Bloquea IPs individuales o rangos usando notación CIDR (192.168.1.0/24)',
                'es' => 'Bloquea IPs individuales o rangos usando notación CIDR (192.168.1.0/24)',
                'sv' => 'Blockera enskilda IP-adresser eller intervall med CIDR-notation (192.168.1.0/24)',
                'pl' => 'Zablokuj pojedyncze adresy IP lub zakresy używając notacji CIDR (192.168.1.0/24)',
                'et' => 'Blokeeri üksikud IP-d või vahemikud kasutades CIDR-märgistust (192.168.1.0/24)'
            ],
            'tip_keyword' => [
                'en' => 'Blocks any submission containing this word or phrase',
                'lt' => 'Blokuoja bet kokį pateikimą, kuriame yra šis žodis ar frazė',
                'it' => 'Blocca qualsiasi invio contenente questa parola o frase',
                'de' => 'Blockiert jede Einreichung, die dieses Wort oder diese Phrase enthält',
                'es_MX' => 'Bloquea cualquier envío que contenga esta palabra o frase',
                'es' => 'Bloquea cualquier envío que contenga esta palabra o frase',
                'sv' => 'Blockerar alla inskickningar som innehåller detta ord eller fras',
                'pl' => 'Blokuje każde zgłoszenie zawierające to słowo lub frazę',
                'et' => 'Blokeerib iga esituse, mis sisaldab seda sõna või fraasi'
            ],
            'enter_value_to_block' => [
                'en' => 'Please enter a value to block.',
                'lt' => 'Įveskite reikšmę, kurią norite blokuoti.',
                'it' => 'Inserisci un valore da bloccare.',
                'de' => 'Bitte geben Sie einen Wert zum Blockieren ein.',
                'es_MX' => 'Por favor ingresa un valor a bloquear.',
                'es' => 'Por favor ingresa un valor a bloquear.',
                'sv' => 'Ange ett värde att blockera.',
                'pl' => 'Wprowadź wartość do zablokowania.',
                'et' => 'Palun sisesta blokeeritav väärtus.'
            ],

            // =====================================================
            // PAGINATION
            // =====================================================
            'page' => [
                'en' => 'Page',
                'lt' => 'Puslapis',
                'it' => 'Pagina',
                'de' => 'Seite',
                'es_MX' => 'Página',
                'es' => 'Página',
                'sv' => 'Sida',
                'pl' => 'Strona',
                'et' => 'Lehekülg'
            ],
            'of' => [
                'en' => 'of',
                'lt' => 'iš',
                'it' => 'di',
                'de' => 'von',
                'es_MX' => 'de',
                'es' => 'de',
                'sv' => 'av',
                'pl' => 'z',
                'et' => '/'
            ],
            'previous' => [
                'en' => 'Previous',
                'lt' => 'Ankstesnis',
                'it' => 'Precedente',
                'de' => 'Zurück',
                'es_MX' => 'Anterior',
                'es' => 'Anterior',
                'sv' => 'Föregående',
                'pl' => 'Poprzedni',
                'et' => 'Eelmine'
            ],
            'next' => [
                'en' => 'Next',
                'lt' => 'Kitas',
                'it' => 'Successivo',
                'de' => 'Weiter',
                'es_MX' => 'Siguiente',
                'es' => 'Siguiente',
                'sv' => 'Nästa',
                'pl' => 'Następny',
                'et' => 'Järgmine'
            ],

            // =====================================================
            // DASHBOARD INTEGRATIONS
            // =====================================================
            'integrations' => [
                'en' => 'Integrations',
                'lt' => 'Integracijos',
                'it' => 'Integrazioni',
                'de' => 'Integrationen',
                'es_MX' => 'Integraciones',
                'es' => 'Integraciones',
                'sv' => 'Integrationer',
                'pl' => 'Integracje',
                'et' => 'Integratsioonid'
            ],
            'contact_form_7' => [
                'en' => 'Contact Form 7',
                'lt' => 'Contact Form 7',
                'it' => 'Contact Form 7',
                'de' => 'Contact Form 7',
                'es_MX' => 'Contact Form 7',
                'es' => 'Contact Form 7',
                'sv' => 'Contact Form 7',
                'pl' => 'Contact Form 7',
                'et' => 'Contact Form 7'
            ],
            'connected' => [
                'en' => 'Connected',
                'lt' => 'Prijungta',
                'it' => 'Connesso',
                'de' => 'Verbunden',
                'es_MX' => 'Conectado',
                'es' => 'Conectado',
                'sv' => 'Ansluten',
                'pl' => 'Połączono',
                'et' => 'Ühendatud'
            ],
            'not_detected' => [
                'en' => 'Not Detected',
                'lt' => 'Neaptikta',
                'it' => 'Non rilevato',
                'de' => 'Nicht erkannt',
                'es_MX' => 'No detectado',
                'es' => 'No detectado',
                'sv' => 'Ej upptäckt',
                'pl' => 'Nie wykryto',
                'et' => 'Ei tuvastatud'
            ],
            'generic_forms' => [
                'en' => 'Generic Forms',
                'lt' => 'Bendrosios formos',
                'it' => 'Moduli generici',
                'de' => 'Generische Formulare',
                'es_MX' => 'Formularios genéricos',
                'es' => 'Formularios genéricos',
                'sv' => 'Generiska formulär',
                'pl' => 'Formularze ogólne',
                'et' => 'Üldised vormid'
            ],
            'active' => [
                'en' => 'Active',
                'lt' => 'Aktyvus',
                'it' => 'Attivo',
                'de' => 'Aktiv',
                'es_MX' => 'Activo',
                'es' => 'Activo',
                'sv' => 'Aktiv',
                'pl' => 'Aktywny',
                'et' => 'Aktiivne'
            ],
            'rest_api' => [
                'en' => 'REST API',
                'lt' => 'REST API',
                'it' => 'REST API',
                'de' => 'REST API',
                'es_MX' => 'REST API',
                'es' => 'REST API',
                'sv' => 'REST API',
                'pl' => 'REST API',
                'et' => 'REST API'
            ],
            'ready' => [
                'en' => 'Ready',
                'lt' => 'Paruošta',
                'it' => 'Pronto',
                'de' => 'Bereit',
                'es_MX' => 'Listo',
                'es' => 'Listo',
                'sv' => 'Redo',
                'pl' => 'Gotowy',
                'et' => 'Valmis'
            ],
        ];
    }
}

/**
 * Helper function to get translations
 */
function honeypot_guard_t($key) {
    $translator = HoneypotGuard_Translations::get_instance();
    return $translator->t($key);
}

/**
 * Helper function to echo translations (escaped)
 */
function honeypot_guard_e($key) {
    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Translation strings are safe
    echo esc_html(honeypot_guard_t($key));
}

/**
 * Helper function to get language-aware URLs
 */
function honeypot_guard_url($key) {
    $translator = HoneypotGuard_Translations::get_instance();
    return esc_url($translator->url($key));
}

